package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ListenerStatusFluent<A extends ListenerStatusFluent<A>> extends BaseFluent<A>{
  public ListenerStatusFluent() {
  }
  public ListenerStatusFluent(ListenerStatus instance) {
    instance = (instance != null ? instance : new ListenerStatus());

    if (instance != null) {
      this.withAttachedRoutes(instance.getAttachedRoutes());
      this.withConditions(instance.getConditions());
      this.withName(instance.getName());
      this.withSupportedKinds(instance.getSupportedKinds());
      this.withAttachedRoutes(instance.getAttachedRoutes());
      this.withConditions(instance.getConditions());
      this.withName(instance.getName());
      this.withSupportedKinds(instance.getSupportedKinds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer attachedRoutes;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String name;
  private ArrayList<RouteGroupKindBuilder> supportedKinds = new ArrayList<RouteGroupKindBuilder>();
  private Map<String,Object> additionalProperties;
  public Integer getAttachedRoutes() {
    return this.attachedRoutes;
  }
  public A withAttachedRoutes(Integer attachedRoutes) {
    this.attachedRoutes=attachedRoutes; return (A) this;
  }
  public boolean hasAttachedRoutes() {
    return this.attachedRoutes != null;
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public A addToSupportedKinds(int index,RouteGroupKind item) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
    if (index < 0 || index >= supportedKinds.size()) { _visitables.get("supportedKinds").add(builder); supportedKinds.add(builder); } else { _visitables.get("supportedKinds").add(index, builder); supportedKinds.add(index, builder);}
    return (A)this;
  }
  public A setToSupportedKinds(int index,RouteGroupKind item) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
    if (index < 0 || index >= supportedKinds.size()) { _visitables.get("supportedKinds").add(builder); supportedKinds.add(builder); } else { _visitables.get("supportedKinds").set(index, builder); supportedKinds.set(index, builder);}
    return (A)this;
  }
  public A addToSupportedKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... items) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").add(builder);this.supportedKinds.add(builder);} return (A)this;
  }
  public A addAllToSupportedKinds(Collection<RouteGroupKind> items) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").add(builder);this.supportedKinds.add(builder);} return (A)this;
  }
  public A removeFromSupportedKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... items) {
    if (this.supportedKinds == null) return (A)this;
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").remove(builder); this.supportedKinds.remove(builder);} return (A)this;
  }
  public A removeAllFromSupportedKinds(Collection<RouteGroupKind> items) {
    if (this.supportedKinds == null) return (A)this;
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").remove(builder); this.supportedKinds.remove(builder);} return (A)this;
  }
  public A removeMatchingFromSupportedKinds(Predicate<RouteGroupKindBuilder> predicate) {
    if (supportedKinds == null) return (A) this;
    final Iterator<RouteGroupKindBuilder> each = supportedKinds.iterator();
    final List visitables = _visitables.get("supportedKinds");
    while (each.hasNext()) {
      RouteGroupKindBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RouteGroupKind> buildSupportedKinds() {
    return supportedKinds != null ? build(supportedKinds) : null;
  }
  public RouteGroupKind buildSupportedKind(int index) {
    return this.supportedKinds.get(index).build();
  }
  public RouteGroupKind buildFirstSupportedKind() {
    return this.supportedKinds.get(0).build();
  }
  public RouteGroupKind buildLastSupportedKind() {
    return this.supportedKinds.get(supportedKinds.size() - 1).build();
  }
  public RouteGroupKind buildMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: supportedKinds) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: supportedKinds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSupportedKinds(List<RouteGroupKind> supportedKinds) {
    if (this.supportedKinds != null) { _visitables.get("supportedKinds").clear();}
    if (supportedKinds != null) {this.supportedKinds = new ArrayList(); for (RouteGroupKind item : supportedKinds){this.addToSupportedKinds(item);}} else { this.supportedKinds = null;} return (A) this;
  }
  public A withSupportedKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... supportedKinds) {
    if (this.supportedKinds != null) {this.supportedKinds.clear(); _visitables.remove("supportedKinds"); }
    if (supportedKinds != null) {for (RouteGroupKind item :supportedKinds){ this.addToSupportedKinds(item);}} return (A) this;
  }
  public boolean hasSupportedKinds() {
    return supportedKinds != null && !supportedKinds.isEmpty();
  }
  public A addNewSupportedKind(String group,String kind) {
    return (A)addToSupportedKinds(new RouteGroupKind(group, kind));
  }
  public SupportedKindsNested<A> addNewSupportedKind() {
    return new SupportedKindsNested(-1, null);
  }
  public SupportedKindsNested<A> addNewSupportedKindLike(RouteGroupKind item) {
    return new SupportedKindsNested(-1, item);
  }
  public SupportedKindsNested<A> setNewSupportedKindLike(int index,RouteGroupKind item) {
    return new SupportedKindsNested(index, item);
  }
  public SupportedKindsNested<A> editSupportedKind(int index) {
    if (supportedKinds.size() <= index) throw new RuntimeException("Can't edit supportedKinds. Index exceeds size.");
    return setNewSupportedKindLike(index, buildSupportedKind(index));
  }
  public SupportedKindsNested<A> editFirstSupportedKind() {
    if (supportedKinds.size() == 0) throw new RuntimeException("Can't edit first supportedKinds. The list is empty.");
    return setNewSupportedKindLike(0, buildSupportedKind(0));
  }
  public SupportedKindsNested<A> editLastSupportedKind() {
    int index = supportedKinds.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last supportedKinds. The list is empty.");
    return setNewSupportedKindLike(index, buildSupportedKind(index));
  }
  public SupportedKindsNested<A> editMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
    int index = -1;
    for (int i=0;i<supportedKinds.size();i++) { 
    if (predicate.test(supportedKinds.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching supportedKinds. No match found.");
    return setNewSupportedKindLike(index, buildSupportedKind(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ListenerStatusFluent that = (ListenerStatusFluent) o;
    if (!java.util.Objects.equals(attachedRoutes, that.attachedRoutes)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(supportedKinds, that.supportedKinds)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(attachedRoutes,  conditions,  name,  supportedKinds,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attachedRoutes != null) { sb.append("attachedRoutes:"); sb.append(attachedRoutes + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (supportedKinds != null && !supportedKinds.isEmpty()) { sb.append("supportedKinds:"); sb.append(supportedKinds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SupportedKindsNested<N> extends RouteGroupKindFluent<SupportedKindsNested<N>> implements Nested<N>{
    SupportedKindsNested(int index,RouteGroupKind item) {
      this.index = index;
      this.builder = new RouteGroupKindBuilder(this, item);
    }
    RouteGroupKindBuilder builder;
    int index;
    public N and() {
      return (N) ListenerStatusFluent.this.setToSupportedKinds(index,builder.build());
    }
    public N endSupportedKind() {
      return and();
    }
    
  }
  
}