package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GatewayClassSpecFluent<A extends GatewayClassSpecFluent<A>> extends BaseFluent<A>{
  public GatewayClassSpecFluent() {
  }
  
  public GatewayClassSpecFluent(GatewayClassSpec instance) {
    this.copyInstance(instance);
  }
  private String controllerName;
  private String description;
  private ParametersReferenceBuilder parametersRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GatewayClassSpec instance) {
    instance = (instance != null ? instance : new GatewayClassSpec());
  
    if (instance != null) {
        this.withControllerName(instance.getControllerName());
        this.withDescription(instance.getDescription());
        this.withParametersRef(instance.getParametersRef());
        this.withControllerName(instance.getControllerName());
        this.withDescription(instance.getDescription());
        this.withParametersRef(instance.getParametersRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getControllerName() {
    return this.controllerName;
  }
  
  public A withControllerName(String controllerName) {
    this.controllerName=controllerName; return (A) this;
  }
  
  public boolean hasControllerName() {
    return this.controllerName != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public ParametersReference buildParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  
  public A withParametersRef(ParametersReference parametersRef) {
    _visitables.get("parametersRef").remove(this.parametersRef);
    if (parametersRef!=null){ this.parametersRef= new ParametersReferenceBuilder(parametersRef); _visitables.get("parametersRef").add(this.parametersRef);} else { this.parametersRef = null; _visitables.get("parametersRef").remove(this.parametersRef); } return (A) this;
  }
  
  public boolean hasParametersRef() {
    return this.parametersRef != null;
  }
  
  public A withNewParametersRef(String group,String kind,String name,String namespace) {
    return (A)withParametersRef(new ParametersReference(group, kind, name, namespace));
  }
  
  public ParametersRefNested<A> withNewParametersRef() {
    return new ParametersRefNested(null);
  }
  
  public ParametersRefNested<A> withNewParametersRefLike(ParametersReference item) {
    return new ParametersRefNested(item);
  }
  
  public ParametersRefNested<A> editParametersRef() {
    return withNewParametersRefLike(java.util.Optional.ofNullable(buildParametersRef()).orElse(null));
  }
  
  public ParametersRefNested<A> editOrNewParametersRef() {
    return withNewParametersRefLike(java.util.Optional.ofNullable(buildParametersRef()).orElse(new ParametersReferenceBuilder().build()));
  }
  
  public ParametersRefNested<A> editOrNewParametersRefLike(ParametersReference item) {
    return withNewParametersRefLike(java.util.Optional.ofNullable(buildParametersRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatewayClassSpecFluent that = (GatewayClassSpecFluent) o;
    if (!java.util.Objects.equals(controllerName, that.controllerName)) return false;
  
    if (!java.util.Objects.equals(description, that.description)) return false;
  
    if (!java.util.Objects.equals(parametersRef, that.parametersRef)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(controllerName,  description,  parametersRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controllerName != null) { sb.append("controllerName:"); sb.append(controllerName + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (parametersRef != null) { sb.append("parametersRef:"); sb.append(parametersRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ParametersRefNested<N> extends ParametersReferenceFluent<ParametersRefNested<N>> implements Nested<N>{
    ParametersRefNested(ParametersReference item) {
      this.builder = new ParametersReferenceBuilder(this, item);
    }
    ParametersReferenceBuilder builder;
    
    public N and() {
      return (N) GatewayClassSpecFluent.this.withParametersRef(builder.build());
    }
    
    public N endParametersRef() {
      return and();
    }
    
  
  }

}