package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HTTPRouteMatchBuilder extends HTTPRouteMatchFluent<HTTPRouteMatchBuilder> implements VisitableBuilder<HTTPRouteMatch,HTTPRouteMatchBuilder>{
  public HTTPRouteMatchBuilder() {
    this(new HTTPRouteMatch());
  }
  
  public HTTPRouteMatchBuilder(HTTPRouteMatchFluent<?> fluent) {
    this(fluent, new HTTPRouteMatch());
  }
  
  public HTTPRouteMatchBuilder(HTTPRouteMatchFluent<?> fluent,HTTPRouteMatch instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HTTPRouteMatchBuilder(HTTPRouteMatch instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HTTPRouteMatchFluent<?> fluent;
  
  public HTTPRouteMatch build() {
    HTTPRouteMatch buildable = new HTTPRouteMatch(fluent.buildHeaders(),fluent.getMethod(),fluent.buildPath(),fluent.buildQueryParams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}