package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRouteRetryFluent<A extends HTTPRouteRetryFluent<A>> extends BaseFluent<A>{
  public HTTPRouteRetryFluent() {
  }
  
  public HTTPRouteRetryFluent(HTTPRouteRetry instance) {
    this.copyInstance(instance);
  }
  private Integer attempts;
  private String backoff;
  private List<Integer> codes = new ArrayList<Integer>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRouteRetry instance) {
    instance = (instance != null ? instance : new HTTPRouteRetry());
    if (instance != null) {
          this.withAttempts(instance.getAttempts());
          this.withBackoff(instance.getBackoff());
          this.withCodes(instance.getCodes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getAttempts() {
    return this.attempts;
  }
  
  public A withAttempts(Integer attempts) {
    this.attempts = attempts;
    return (A) this;
  }
  
  public boolean hasAttempts() {
    return this.attempts != null;
  }
  
  public String getBackoff() {
    return this.backoff;
  }
  
  public A withBackoff(String backoff) {
    this.backoff = backoff;
    return (A) this;
  }
  
  public boolean hasBackoff() {
    return this.backoff != null;
  }
  
  public A addToCodes(int index,Integer item) {
    if (this.codes == null) {this.codes = new ArrayList<Integer>();}
    this.codes.add(index, item);
    return (A)this;
  }
  
  public A setToCodes(int index,Integer item) {
    if (this.codes == null) {this.codes = new ArrayList<Integer>();}
    this.codes.set(index, item); return (A)this;
  }
  
  public A addToCodes(java.lang.Integer... items) {
    if (this.codes == null) {this.codes = new ArrayList<Integer>();}
    for (Integer item : items) {this.codes.add(item);} return (A)this;
  }
  
  public A addAllToCodes(Collection<Integer> items) {
    if (this.codes == null) {this.codes = new ArrayList<Integer>();}
    for (Integer item : items) {this.codes.add(item);} return (A)this;
  }
  
  public A removeFromCodes(java.lang.Integer... items) {
    if (this.codes == null) return (A)this;
    for (Integer item : items) { this.codes.remove(item);} return (A)this;
  }
  
  public A removeAllFromCodes(Collection<Integer> items) {
    if (this.codes == null) return (A)this;
    for (Integer item : items) { this.codes.remove(item);} return (A)this;
  }
  
  public List<Integer> getCodes() {
    return this.codes;
  }
  
  public Integer getCode(int index) {
    return this.codes.get(index);
  }
  
  public Integer getFirstCode() {
    return this.codes.get(0);
  }
  
  public Integer getLastCode() {
    return this.codes.get(codes.size() - 1);
  }
  
  public Integer getMatchingCode(Predicate<Integer> predicate) {
      for (Integer item : codes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCode(Predicate<Integer> predicate) {
      for (Integer item : codes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCodes(List<Integer> codes) {
    if (codes != null) {
        this.codes = new ArrayList();
        for (Integer item : codes) {
          this.addToCodes(item);
        }
    } else {
      this.codes = null;
    }
    return (A) this;
  }
  
  public A withCodes(java.lang.Integer... codes) {
    if (this.codes != null) {
        this.codes.clear();
        _visitables.remove("codes");
    }
    if (codes != null) {
      for (Integer item : codes) {
        this.addToCodes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCodes() {
    return this.codes != null && !this.codes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteRetryFluent that = (HTTPRouteRetryFluent) o;
    if (!java.util.Objects.equals(attempts, that.attempts)) return false;
    if (!java.util.Objects.equals(backoff, that.backoff)) return false;
    if (!java.util.Objects.equals(codes, that.codes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attempts,  backoff,  codes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attempts != null) { sb.append("attempts:"); sb.append(attempts + ","); }
    if (backoff != null) { sb.append("backoff:"); sb.append(backoff + ","); }
    if (codes != null && !codes.isEmpty()) { sb.append("codes:"); sb.append(codes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}