package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionNameFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionNameBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionName;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BackendTLSPolicySpecFluent<A extends BackendTLSPolicySpecFluent<A>> extends BaseFluent<A>{
  public BackendTLSPolicySpecFluent() {
  }
  
  public BackendTLSPolicySpecFluent(BackendTLSPolicySpec instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> options;
  private ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder> targetRefs = new ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder>();
  private BackendTLSPolicyValidationBuilder validation;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BackendTLSPolicySpec instance) {
    instance = (instance != null ? instance : new BackendTLSPolicySpec());
    if (instance != null) {
          this.withOptions(instance.getOptions());
          this.withTargetRefs(instance.getTargetRefs());
          this.withValidation(instance.getValidation());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToOptions(String key,String value) {
    if(this.options == null && key != null && value != null) { this.options = new LinkedHashMap(); }
    if(key != null && value != null) {this.options.put(key, value);} return (A)this;
  }
  
  public A addToOptions(Map<String,String> map) {
    if(this.options == null && map != null) { this.options = new LinkedHashMap(); }
    if(map != null) { this.options.putAll(map);} return (A)this;
  }
  
  public A removeFromOptions(String key) {
    if(this.options == null) { return (A) this; }
    if(key != null && this.options != null) {this.options.remove(key);} return (A)this;
  }
  
  public A removeFromOptions(Map<String,String> map) {
    if(this.options == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.options != null){this.options.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getOptions() {
    return this.options;
  }
  
  public <K,V>A withOptions(Map<String,String> options) {
    if (options == null) {
      this.options = null;
    } else {
      this.options = new LinkedHashMap(options);
    }
    return (A) this;
  }
  
  public boolean hasOptions() {
    return this.options != null;
  }
  
  public A addToTargetRefs(int index,LocalPolicyTargetReferenceWithSectionName item) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder>();}
    LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
    if (index < 0 || index >= targetRefs.size()) { _visitables.get("targetRefs").add(builder); targetRefs.add(builder); } else { _visitables.get("targetRefs").add(index, builder); targetRefs.add(index, builder);}
    return (A)this;
  }
  
  public A setToTargetRefs(int index,LocalPolicyTargetReferenceWithSectionName item) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder>();}
    LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
    if (index < 0 || index >= targetRefs.size()) { _visitables.get("targetRefs").add(builder); targetRefs.add(builder); } else { _visitables.get("targetRefs").set(index, builder); targetRefs.set(index, builder);}
    return (A)this;
  }
  
  public A addToTargetRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionName... items) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder>();}
    for (LocalPolicyTargetReferenceWithSectionName item : items) {LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);_visitables.get("targetRefs").add(builder);this.targetRefs.add(builder);} return (A)this;
  }
  
  public A addAllToTargetRefs(Collection<LocalPolicyTargetReferenceWithSectionName> items) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder>();}
    for (LocalPolicyTargetReferenceWithSectionName item : items) {LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);_visitables.get("targetRefs").add(builder);this.targetRefs.add(builder);} return (A)this;
  }
  
  public A removeFromTargetRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionName... items) {
    if (this.targetRefs == null) return (A)this;
    for (LocalPolicyTargetReferenceWithSectionName item : items) {LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);_visitables.get("targetRefs").remove(builder); this.targetRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTargetRefs(Collection<LocalPolicyTargetReferenceWithSectionName> items) {
    if (this.targetRefs == null) return (A)this;
    for (LocalPolicyTargetReferenceWithSectionName item : items) {LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);_visitables.get("targetRefs").remove(builder); this.targetRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTargetRefs(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
    if (targetRefs == null) return (A) this;
    final Iterator<LocalPolicyTargetReferenceWithSectionNameBuilder> each = targetRefs.iterator();
    final List visitables = _visitables.get("targetRefs");
    while (each.hasNext()) {
      LocalPolicyTargetReferenceWithSectionNameBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalPolicyTargetReferenceWithSectionName> buildTargetRefs() {
    return this.targetRefs != null ? build(targetRefs) : null;
  }
  
  public LocalPolicyTargetReferenceWithSectionName buildTargetRef(int index) {
    return this.targetRefs.get(index).build();
  }
  
  public LocalPolicyTargetReferenceWithSectionName buildFirstTargetRef() {
    return this.targetRefs.get(0).build();
  }
  
  public LocalPolicyTargetReferenceWithSectionName buildLastTargetRef() {
    return this.targetRefs.get(targetRefs.size() - 1).build();
  }
  
  public LocalPolicyTargetReferenceWithSectionName buildMatchingTargetRef(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
      for (LocalPolicyTargetReferenceWithSectionNameBuilder item : targetRefs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTargetRef(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
      for (LocalPolicyTargetReferenceWithSectionNameBuilder item : targetRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTargetRefs(List<LocalPolicyTargetReferenceWithSectionName> targetRefs) {
    if (this.targetRefs != null) {
      this._visitables.get("targetRefs").clear();
    }
    if (targetRefs != null) {
        this.targetRefs = new ArrayList();
        for (LocalPolicyTargetReferenceWithSectionName item : targetRefs) {
          this.addToTargetRefs(item);
        }
    } else {
      this.targetRefs = null;
    }
    return (A) this;
  }
  
  public A withTargetRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionName... targetRefs) {
    if (this.targetRefs != null) {
        this.targetRefs.clear();
        _visitables.remove("targetRefs");
    }
    if (targetRefs != null) {
      for (LocalPolicyTargetReferenceWithSectionName item : targetRefs) {
        this.addToTargetRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTargetRefs() {
    return this.targetRefs != null && !this.targetRefs.isEmpty();
  }
  
  public A addNewTargetRef(String group,String kind,String name,String sectionName) {
    return (A)addToTargetRefs(new LocalPolicyTargetReferenceWithSectionName(group, kind, name, sectionName));
  }
  
  public TargetRefsNested<A> addNewTargetRef() {
    return new TargetRefsNested(-1, null);
  }
  
  public TargetRefsNested<A> addNewTargetRefLike(LocalPolicyTargetReferenceWithSectionName item) {
    return new TargetRefsNested(-1, item);
  }
  
  public TargetRefsNested<A> setNewTargetRefLike(int index,LocalPolicyTargetReferenceWithSectionName item) {
    return new TargetRefsNested(index, item);
  }
  
  public TargetRefsNested<A> editTargetRef(int index) {
    if (targetRefs.size() <= index) throw new RuntimeException("Can't edit targetRefs. Index exceeds size.");
    return setNewTargetRefLike(index, buildTargetRef(index));
  }
  
  public TargetRefsNested<A> editFirstTargetRef() {
    if (targetRefs.size() == 0) throw new RuntimeException("Can't edit first targetRefs. The list is empty.");
    return setNewTargetRefLike(0, buildTargetRef(0));
  }
  
  public TargetRefsNested<A> editLastTargetRef() {
    int index = targetRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last targetRefs. The list is empty.");
    return setNewTargetRefLike(index, buildTargetRef(index));
  }
  
  public TargetRefsNested<A> editMatchingTargetRef(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
    int index = -1;
    for (int i=0;i<targetRefs.size();i++) { 
    if (predicate.test(targetRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching targetRefs. No match found.");
    return setNewTargetRefLike(index, buildTargetRef(index));
  }
  
  public BackendTLSPolicyValidation buildValidation() {
    return this.validation != null ? this.validation.build() : null;
  }
  
  public A withValidation(BackendTLSPolicyValidation validation) {
    this._visitables.remove("validation");
    if (validation != null) {
        this.validation = new BackendTLSPolicyValidationBuilder(validation);
        this._visitables.get("validation").add(this.validation);
    } else {
        this.validation = null;
        this._visitables.get("validation").remove(this.validation);
    }
    return (A) this;
  }
  
  public boolean hasValidation() {
    return this.validation != null;
  }
  
  public ValidationNested<A> withNewValidation() {
    return new ValidationNested(null);
  }
  
  public ValidationNested<A> withNewValidationLike(BackendTLSPolicyValidation item) {
    return new ValidationNested(item);
  }
  
  public ValidationNested<A> editValidation() {
    return withNewValidationLike(java.util.Optional.ofNullable(buildValidation()).orElse(null));
  }
  
  public ValidationNested<A> editOrNewValidation() {
    return withNewValidationLike(java.util.Optional.ofNullable(buildValidation()).orElse(new BackendTLSPolicyValidationBuilder().build()));
  }
  
  public ValidationNested<A> editOrNewValidationLike(BackendTLSPolicyValidation item) {
    return withNewValidationLike(java.util.Optional.ofNullable(buildValidation()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackendTLSPolicySpecFluent that = (BackendTLSPolicySpecFluent) o;
    if (!java.util.Objects.equals(options, that.options)) return false;
    if (!java.util.Objects.equals(targetRefs, that.targetRefs)) return false;
    if (!java.util.Objects.equals(validation, that.validation)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(options,  targetRefs,  validation,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (options != null && !options.isEmpty()) { sb.append("options:"); sb.append(options + ","); }
    if (targetRefs != null && !targetRefs.isEmpty()) { sb.append("targetRefs:"); sb.append(targetRefs + ","); }
    if (validation != null) { sb.append("validation:"); sb.append(validation + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TargetRefsNested<N> extends LocalPolicyTargetReferenceWithSectionNameFluent<TargetRefsNested<N>> implements Nested<N>{
    TargetRefsNested(int index,LocalPolicyTargetReferenceWithSectionName item) {
      this.index = index;
      this.builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(this, item);
    }
    LocalPolicyTargetReferenceWithSectionNameBuilder builder;
    int index;
    
    public N and() {
      return (N) BackendTLSPolicySpecFluent.this.setToTargetRefs(index,builder.build());
    }
    
    public N endTargetRef() {
      return and();
    }
    
  
  }
  public class ValidationNested<N> extends BackendTLSPolicyValidationFluent<ValidationNested<N>> implements Nested<N>{
    ValidationNested(BackendTLSPolicyValidation item) {
      this.builder = new BackendTLSPolicyValidationBuilder(this, item);
    }
    BackendTLSPolicyValidationBuilder builder;
    
    public N and() {
      return (N) BackendTLSPolicySpecFluent.this.withValidation(builder.build());
    }
    
    public N endValidation() {
      return and();
    }
    
  
  }

}