/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.BackendTLSPolicyValidation;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.SubjectAltName;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.SubjectAltNameBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.SubjectAltNameFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BackendTLSPolicyValidationFluent<A extends BackendTLSPolicyValidationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LocalObjectReferenceBuilder> caCertificateRefs = new ArrayList();
    private String hostname;
    private ArrayList<SubjectAltNameBuilder> subjectAltNames = new ArrayList();
    private String wellKnownCACertificates;
    private Map<String, Object> additionalProperties;

    public BackendTLSPolicyValidationFluent() {
    }

    public BackendTLSPolicyValidationFluent(BackendTLSPolicyValidation instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BackendTLSPolicyValidation instance) {
        BackendTLSPolicyValidation backendTLSPolicyValidation = instance = instance != null ? instance : new BackendTLSPolicyValidation();
        if (instance != null) {
            this.withCaCertificateRefs(instance.getCaCertificateRefs());
            this.withHostname(instance.getHostname());
            this.withSubjectAltNames(instance.getSubjectAltNames());
            this.withWellKnownCACertificates(instance.getWellKnownCACertificates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCaCertificateRefs(int index, LocalObjectReference item) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.caCertificateRefs.size()) {
            this._visitables.get((Object)"caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        } else {
            this._visitables.get((Object)"caCertificateRefs").add(index, builder);
            this.caCertificateRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCaCertificateRefs(int index, LocalObjectReference item) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.caCertificateRefs.size()) {
            this._visitables.get((Object)"caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        } else {
            this._visitables.get((Object)"caCertificateRefs").set(index, builder);
            this.caCertificateRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCaCertificateRefs(LocalObjectReference ... items) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCaCertificateRefs(Collection<LocalObjectReference> items) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCaCertificateRefs(LocalObjectReference ... items) {
        if (this.caCertificateRefs == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertificateRefs").remove((Object)builder);
            this.caCertificateRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCaCertificateRefs(Collection<LocalObjectReference> items) {
        if (this.caCertificateRefs == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertificateRefs").remove((Object)builder);
            this.caCertificateRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCaCertificateRefs(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.caCertificateRefs == null) {
            return (A)((Object)this);
        }
        Iterator<LocalObjectReferenceBuilder> each = this.caCertificateRefs.iterator();
        List visitables = this._visitables.get((Object)"caCertificateRefs");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LocalObjectReference> buildCaCertificateRefs() {
        return this.caCertificateRefs != null ? BackendTLSPolicyValidationFluent.build(this.caCertificateRefs) : null;
    }

    public LocalObjectReference buildCaCertificateRef(int index) {
        return this.caCertificateRefs.get(index).build();
    }

    public LocalObjectReference buildFirstCaCertificateRef() {
        return this.caCertificateRefs.get(0).build();
    }

    public LocalObjectReference buildLastCaCertificateRef() {
        return this.caCertificateRefs.get(this.caCertificateRefs.size() - 1).build();
    }

    public LocalObjectReference buildMatchingCaCertificateRef(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.caCertificateRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCaCertificateRef(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.caCertificateRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCaCertificateRefs(List<LocalObjectReference> caCertificateRefs) {
        if (this.caCertificateRefs != null) {
            this._visitables.get((Object)"caCertificateRefs").clear();
        }
        if (caCertificateRefs != null) {
            this.caCertificateRefs = new ArrayList();
            for (LocalObjectReference item : caCertificateRefs) {
                this.addToCaCertificateRefs(item);
            }
        } else {
            this.caCertificateRefs = null;
        }
        return (A)((Object)this);
    }

    public A withCaCertificateRefs(LocalObjectReference ... caCertificateRefs) {
        if (this.caCertificateRefs != null) {
            this.caCertificateRefs.clear();
            this._visitables.remove((Object)"caCertificateRefs");
        }
        if (caCertificateRefs != null) {
            for (LocalObjectReference item : caCertificateRefs) {
                this.addToCaCertificateRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCaCertificateRefs() {
        return this.caCertificateRefs != null && !this.caCertificateRefs.isEmpty();
    }

    public A addNewCaCertificateRef(String group, String kind, String name) {
        return this.addToCaCertificateRefs(new LocalObjectReference(group, kind, name));
    }

    public CaCertificateRefsNested<A> addNewCaCertificateRef() {
        return new CaCertificateRefsNested(-1, null);
    }

    public CaCertificateRefsNested<A> addNewCaCertificateRefLike(LocalObjectReference item) {
        return new CaCertificateRefsNested(-1, item);
    }

    public CaCertificateRefsNested<A> setNewCaCertificateRefLike(int index, LocalObjectReference item) {
        return new CaCertificateRefsNested(index, item);
    }

    public CaCertificateRefsNested<A> editCaCertificateRef(int index) {
        if (this.caCertificateRefs.size() <= index) {
            throw new RuntimeException("Can't edit caCertificateRefs. Index exceeds size.");
        }
        return this.setNewCaCertificateRefLike(index, this.buildCaCertificateRef(index));
    }

    public CaCertificateRefsNested<A> editFirstCaCertificateRef() {
        if (this.caCertificateRefs.size() == 0) {
            throw new RuntimeException("Can't edit first caCertificateRefs. The list is empty.");
        }
        return this.setNewCaCertificateRefLike(0, this.buildCaCertificateRef(0));
    }

    public CaCertificateRefsNested<A> editLastCaCertificateRef() {
        int index = this.caCertificateRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last caCertificateRefs. The list is empty.");
        }
        return this.setNewCaCertificateRefLike(index, this.buildCaCertificateRef(index));
    }

    public CaCertificateRefsNested<A> editMatchingCaCertificateRef(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.caCertificateRefs.size(); ++i) {
            if (!predicate.test(this.caCertificateRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching caCertificateRefs. No match found.");
        }
        return this.setNewCaCertificateRefLike(index, this.buildCaCertificateRef(index));
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)((Object)this);
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public A addToSubjectAltNames(int index, SubjectAltName item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList();
        }
        SubjectAltNameBuilder builder = new SubjectAltNameBuilder(item);
        if (index < 0 || index >= this.subjectAltNames.size()) {
            this._visitables.get((Object)"subjectAltNames").add(builder);
            this.subjectAltNames.add(builder);
        } else {
            this._visitables.get((Object)"subjectAltNames").add(index, builder);
            this.subjectAltNames.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubjectAltNames(int index, SubjectAltName item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList();
        }
        SubjectAltNameBuilder builder = new SubjectAltNameBuilder(item);
        if (index < 0 || index >= this.subjectAltNames.size()) {
            this._visitables.get((Object)"subjectAltNames").add(builder);
            this.subjectAltNames.add(builder);
        } else {
            this._visitables.get((Object)"subjectAltNames").set(index, builder);
            this.subjectAltNames.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubjectAltNames(SubjectAltName ... items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList();
        }
        for (SubjectAltName item : items) {
            SubjectAltNameBuilder builder = new SubjectAltNameBuilder(item);
            this._visitables.get((Object)"subjectAltNames").add(builder);
            this.subjectAltNames.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubjectAltNames(Collection<SubjectAltName> items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList();
        }
        for (SubjectAltName item : items) {
            SubjectAltNameBuilder builder = new SubjectAltNameBuilder(item);
            this._visitables.get((Object)"subjectAltNames").add(builder);
            this.subjectAltNames.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubjectAltNames(SubjectAltName ... items) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        for (SubjectAltName item : items) {
            SubjectAltNameBuilder builder = new SubjectAltNameBuilder(item);
            this._visitables.get((Object)"subjectAltNames").remove((Object)builder);
            this.subjectAltNames.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubjectAltNames(Collection<SubjectAltName> items) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        for (SubjectAltName item : items) {
            SubjectAltNameBuilder builder = new SubjectAltNameBuilder(item);
            this._visitables.get((Object)"subjectAltNames").remove((Object)builder);
            this.subjectAltNames.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubjectAltNames(Predicate<SubjectAltNameBuilder> predicate) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        Iterator<SubjectAltNameBuilder> each = this.subjectAltNames.iterator();
        List visitables = this._visitables.get((Object)"subjectAltNames");
        while (each.hasNext()) {
            SubjectAltNameBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SubjectAltName> buildSubjectAltNames() {
        return this.subjectAltNames != null ? BackendTLSPolicyValidationFluent.build(this.subjectAltNames) : null;
    }

    public SubjectAltName buildSubjectAltName(int index) {
        return this.subjectAltNames.get(index).build();
    }

    public SubjectAltName buildFirstSubjectAltName() {
        return this.subjectAltNames.get(0).build();
    }

    public SubjectAltName buildLastSubjectAltName() {
        return this.subjectAltNames.get(this.subjectAltNames.size() - 1).build();
    }

    public SubjectAltName buildMatchingSubjectAltName(Predicate<SubjectAltNameBuilder> predicate) {
        for (SubjectAltNameBuilder item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubjectAltName(Predicate<SubjectAltNameBuilder> predicate) {
        for (SubjectAltNameBuilder item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjectAltNames(List<SubjectAltName> subjectAltNames) {
        if (this.subjectAltNames != null) {
            this._visitables.get((Object)"subjectAltNames").clear();
        }
        if (subjectAltNames != null) {
            this.subjectAltNames = new ArrayList();
            for (SubjectAltName item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        } else {
            this.subjectAltNames = null;
        }
        return (A)((Object)this);
    }

    public A withSubjectAltNames(SubjectAltName ... subjectAltNames) {
        if (this.subjectAltNames != null) {
            this.subjectAltNames.clear();
            this._visitables.remove((Object)"subjectAltNames");
        }
        if (subjectAltNames != null) {
            for (SubjectAltName item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubjectAltNames() {
        return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
    }

    public A addNewSubjectAltName(String hostname, String type, String uri) {
        return this.addToSubjectAltNames(new SubjectAltName(hostname, type, uri));
    }

    public SubjectAltNamesNested<A> addNewSubjectAltName() {
        return new SubjectAltNamesNested(-1, null);
    }

    public SubjectAltNamesNested<A> addNewSubjectAltNameLike(SubjectAltName item) {
        return new SubjectAltNamesNested(-1, item);
    }

    public SubjectAltNamesNested<A> setNewSubjectAltNameLike(int index, SubjectAltName item) {
        return new SubjectAltNamesNested(index, item);
    }

    public SubjectAltNamesNested<A> editSubjectAltName(int index) {
        if (this.subjectAltNames.size() <= index) {
            throw new RuntimeException("Can't edit subjectAltNames. Index exceeds size.");
        }
        return this.setNewSubjectAltNameLike(index, this.buildSubjectAltName(index));
    }

    public SubjectAltNamesNested<A> editFirstSubjectAltName() {
        if (this.subjectAltNames.size() == 0) {
            throw new RuntimeException("Can't edit first subjectAltNames. The list is empty.");
        }
        return this.setNewSubjectAltNameLike(0, this.buildSubjectAltName(0));
    }

    public SubjectAltNamesNested<A> editLastSubjectAltName() {
        int index = this.subjectAltNames.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjectAltNames. The list is empty.");
        }
        return this.setNewSubjectAltNameLike(index, this.buildSubjectAltName(index));
    }

    public SubjectAltNamesNested<A> editMatchingSubjectAltName(Predicate<SubjectAltNameBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjectAltNames.size(); ++i) {
            if (!predicate.test(this.subjectAltNames.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjectAltNames. No match found.");
        }
        return this.setNewSubjectAltNameLike(index, this.buildSubjectAltName(index));
    }

    public String getWellKnownCACertificates() {
        return this.wellKnownCACertificates;
    }

    public A withWellKnownCACertificates(String wellKnownCACertificates) {
        this.wellKnownCACertificates = wellKnownCACertificates;
        return (A)((Object)this);
    }

    public boolean hasWellKnownCACertificates() {
        return this.wellKnownCACertificates != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackendTLSPolicyValidationFluent that = (BackendTLSPolicyValidationFluent)((Object)o);
        if (!Objects.equals(this.caCertificateRefs, that.caCertificateRefs)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.subjectAltNames, that.subjectAltNames)) {
            return false;
        }
        if (!Objects.equals(this.wellKnownCACertificates, that.wellKnownCACertificates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.caCertificateRefs, this.hostname, this.subjectAltNames, this.wellKnownCACertificates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caCertificateRefs != null && !this.caCertificateRefs.isEmpty()) {
            sb.append("caCertificateRefs:");
            sb.append(this.caCertificateRefs + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.subjectAltNames != null && !this.subjectAltNames.isEmpty()) {
            sb.append("subjectAltNames:");
            sb.append(this.subjectAltNames + ",");
        }
        if (this.wellKnownCACertificates != null) {
            sb.append("wellKnownCACertificates:");
            sb.append(this.wellKnownCACertificates + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubjectAltNamesNested<N>
    extends SubjectAltNameFluent<SubjectAltNamesNested<N>>
    implements Nested<N> {
        SubjectAltNameBuilder builder;
        int index;

        SubjectAltNamesNested(int index, SubjectAltName item) {
            this.index = index;
            this.builder = new SubjectAltNameBuilder(this, item);
        }

        public N and() {
            return (N)BackendTLSPolicyValidationFluent.this.setToSubjectAltNames(this.index, this.builder.build());
        }

        public N endSubjectAltName() {
            return this.and();
        }
    }

    public class CaCertificateRefsNested<N>
    extends LocalObjectReferenceFluent<CaCertificateRefsNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        CaCertificateRefsNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)BackendTLSPolicyValidationFluent.this.setToCaCertificateRefs(this.index, this.builder.build());
        }

        public N endCaCertificateRef() {
            return this.and();
        }
    }
}

