package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GRPCRouteSpecFluent<A extends GRPCRouteSpecFluent<A>> extends BaseFluent<A>{
  public GRPCRouteSpecFluent() {
  }
  
  public GRPCRouteSpecFluent(GRPCRouteSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> hostnames = new ArrayList<String>();
  private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList<ParentReferenceBuilder>();
  private ArrayList<GRPCRouteRuleBuilder> rules = new ArrayList<GRPCRouteRuleBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GRPCRouteSpec instance) {
    instance = (instance != null ? instance : new GRPCRouteSpec());
    if (instance != null) {
          this.withHostnames(instance.getHostnames());
          this.withParentRefs(instance.getParentRefs());
          this.withRules(instance.getRules());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToHostnames(int index,String item) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    this.hostnames.add(index, item);
    return (A)this;
  }
  
  public A setToHostnames(int index,String item) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    this.hostnames.set(index, item); return (A)this;
  }
  
  public A addToHostnames(java.lang.String... items) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    for (String item : items) {this.hostnames.add(item);} return (A)this;
  }
  
  public A addAllToHostnames(Collection<String> items) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    for (String item : items) {this.hostnames.add(item);} return (A)this;
  }
  
  public A removeFromHostnames(java.lang.String... items) {
    if (this.hostnames == null) return (A)this;
    for (String item : items) { this.hostnames.remove(item);} return (A)this;
  }
  
  public A removeAllFromHostnames(Collection<String> items) {
    if (this.hostnames == null) return (A)this;
    for (String item : items) { this.hostnames.remove(item);} return (A)this;
  }
  
  public List<String> getHostnames() {
    return this.hostnames;
  }
  
  public String getHostname(int index) {
    return this.hostnames.get(index);
  }
  
  public String getFirstHostname() {
    return this.hostnames.get(0);
  }
  
  public String getLastHostname() {
    return this.hostnames.get(hostnames.size() - 1);
  }
  
  public String getMatchingHostname(Predicate<String> predicate) {
      for (String item : hostnames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingHostname(Predicate<String> predicate) {
      for (String item : hostnames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHostnames(List<String> hostnames) {
    if (hostnames != null) {
        this.hostnames = new ArrayList();
        for (String item : hostnames) {
          this.addToHostnames(item);
        }
    } else {
      this.hostnames = null;
    }
    return (A) this;
  }
  
  public A withHostnames(java.lang.String... hostnames) {
    if (this.hostnames != null) {
        this.hostnames.clear();
        _visitables.remove("hostnames");
    }
    if (hostnames != null) {
      for (String item : hostnames) {
        this.addToHostnames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHostnames() {
    return this.hostnames != null && !this.hostnames.isEmpty();
  }
  
  public A addToParentRefs(int index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
    if (index < 0 || index >= parentRefs.size()) {
        _visitables.get("parentRefs").add(builder);
        parentRefs.add(builder);
    } else {
        _visitables.get("parentRefs").add(builder);
        parentRefs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToParentRefs(int index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
    if (index < 0 || index >= parentRefs.size()) {
        _visitables.get("parentRefs").add(builder);
        parentRefs.add(builder);
    } else {
        _visitables.get("parentRefs").add(builder);
        parentRefs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference... items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(builder);this.parentRefs.add(builder);} return (A)this;
  }
  
  public A addAllToParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(builder);this.parentRefs.add(builder);} return (A)this;
  }
  
  public A removeFromParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference... items) {
    if (this.parentRefs == null) return (A)this;
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").remove(builder); this.parentRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) return (A)this;
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").remove(builder); this.parentRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
    if (parentRefs == null) return (A) this;
    final Iterator<ParentReferenceBuilder> each = parentRefs.iterator();
    final List visitables = _visitables.get("parentRefs");
    while (each.hasNext()) {
      ParentReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ParentReference> buildParentRefs() {
    return this.parentRefs != null ? build(parentRefs) : null;
  }
  
  public ParentReference buildParentRef(int index) {
    return this.parentRefs.get(index).build();
  }
  
  public ParentReference buildFirstParentRef() {
    return this.parentRefs.get(0).build();
  }
  
  public ParentReference buildLastParentRef() {
    return this.parentRefs.get(parentRefs.size() - 1).build();
  }
  
  public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
      for (ParentReferenceBuilder item : parentRefs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
      for (ParentReferenceBuilder item : parentRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParentRefs(List<ParentReference> parentRefs) {
    if (this.parentRefs != null) {
      this._visitables.get("parentRefs").clear();
    }
    if (parentRefs != null) {
        this.parentRefs = new ArrayList();
        for (ParentReference item : parentRefs) {
          this.addToParentRefs(item);
        }
    } else {
      this.parentRefs = null;
    }
    return (A) this;
  }
  
  public A withParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference... parentRefs) {
    if (this.parentRefs != null) {
        this.parentRefs.clear();
        _visitables.remove("parentRefs");
    }
    if (parentRefs != null) {
      for (ParentReference item : parentRefs) {
        this.addToParentRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParentRefs() {
    return this.parentRefs != null && !this.parentRefs.isEmpty();
  }
  
  public ParentRefsNested<A> addNewParentRef() {
    return new ParentRefsNested(-1, null);
  }
  
  public ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
    return new ParentRefsNested(-1, item);
  }
  
  public ParentRefsNested<A> setNewParentRefLike(int index,ParentReference item) {
    return new ParentRefsNested(index, item);
  }
  
  public ParentRefsNested<A> editParentRef(int index) {
    if (parentRefs.size() <= index) throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  
  public ParentRefsNested<A> editFirstParentRef() {
    if (parentRefs.size() == 0) throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
    return setNewParentRefLike(0, buildParentRef(0));
  }
  
  public ParentRefsNested<A> editLastParentRef() {
    int index = parentRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  
  public ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parentRefs.size();i++) { 
    if (predicate.test(parentRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parentRefs. No match found.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  
  public A addToRules(int index,GRPCRouteRule item) {
    if (this.rules == null) {this.rules = new ArrayList<GRPCRouteRuleBuilder>();}
    GRPCRouteRuleBuilder builder = new GRPCRouteRuleBuilder(item);
    if (index < 0 || index >= rules.size()) {
        _visitables.get("rules").add(builder);
        rules.add(builder);
    } else {
        _visitables.get("rules").add(builder);
        rules.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRules(int index,GRPCRouteRule item) {
    if (this.rules == null) {this.rules = new ArrayList<GRPCRouteRuleBuilder>();}
    GRPCRouteRuleBuilder builder = new GRPCRouteRuleBuilder(item);
    if (index < 0 || index >= rules.size()) {
        _visitables.get("rules").add(builder);
        rules.add(builder);
    } else {
        _visitables.get("rules").add(builder);
        rules.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRules(io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCRouteRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<GRPCRouteRuleBuilder>();}
    for (GRPCRouteRule item : items) {GRPCRouteRuleBuilder builder = new GRPCRouteRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A addAllToRules(Collection<GRPCRouteRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<GRPCRouteRuleBuilder>();}
    for (GRPCRouteRule item : items) {GRPCRouteRuleBuilder builder = new GRPCRouteRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A removeFromRules(io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCRouteRule... items) {
    if (this.rules == null) return (A)this;
    for (GRPCRouteRule item : items) {GRPCRouteRuleBuilder builder = new GRPCRouteRuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRules(Collection<GRPCRouteRule> items) {
    if (this.rules == null) return (A)this;
    for (GRPCRouteRule item : items) {GRPCRouteRuleBuilder builder = new GRPCRouteRuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRules(Predicate<GRPCRouteRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<GRPCRouteRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      GRPCRouteRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GRPCRouteRule> buildRules() {
    return this.rules != null ? build(rules) : null;
  }
  
  public GRPCRouteRule buildRule(int index) {
    return this.rules.get(index).build();
  }
  
  public GRPCRouteRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  
  public GRPCRouteRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  
  public GRPCRouteRule buildMatchingRule(Predicate<GRPCRouteRuleBuilder> predicate) {
      for (GRPCRouteRuleBuilder item : rules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRule(Predicate<GRPCRouteRuleBuilder> predicate) {
      for (GRPCRouteRuleBuilder item : rules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRules(List<GRPCRouteRule> rules) {
    if (this.rules != null) {
      this._visitables.get("rules").clear();
    }
    if (rules != null) {
        this.rules = new ArrayList();
        for (GRPCRouteRule item : rules) {
          this.addToRules(item);
        }
    } else {
      this.rules = null;
    }
    return (A) this;
  }
  
  public A withRules(io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCRouteRule... rules) {
    if (this.rules != null) {
        this.rules.clear();
        _visitables.remove("rules");
    }
    if (rules != null) {
      for (GRPCRouteRule item : rules) {
        this.addToRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRules() {
    return this.rules != null && !this.rules.isEmpty();
  }
  
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  
  public RulesNested<A> addNewRuleLike(GRPCRouteRule item) {
    return new RulesNested(-1, item);
  }
  
  public RulesNested<A> setNewRuleLike(int index,GRPCRouteRule item) {
    return new RulesNested(index, item);
  }
  
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editMatchingRule(Predicate<GRPCRouteRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GRPCRouteSpecFluent that = (GRPCRouteSpecFluent) o;
    if (!java.util.Objects.equals(hostnames, that.hostnames)) return false;
    if (!java.util.Objects.equals(parentRefs, that.parentRefs)) return false;
    if (!java.util.Objects.equals(rules, that.rules)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostnames,  parentRefs,  rules,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostnames != null && !hostnames.isEmpty()) { sb.append("hostnames:"); sb.append(hostnames + ","); }
    if (parentRefs != null && !parentRefs.isEmpty()) { sb.append("parentRefs:"); sb.append(parentRefs + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ParentRefsNested<N> extends ParentReferenceFluent<ParentRefsNested<N>> implements Nested<N>{
    ParentRefsNested(int index,ParentReference item) {
      this.index = index;
      this.builder = new ParentReferenceBuilder(this, item);
    }
    ParentReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) GRPCRouteSpecFluent.this.setToParentRefs(index,builder.build());
    }
    
    public N endParentRef() {
      return and();
    }
    
  
  }
  public class RulesNested<N> extends GRPCRouteRuleFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,GRPCRouteRule item) {
      this.index = index;
      this.builder = new GRPCRouteRuleBuilder(this, item);
    }
    GRPCRouteRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) GRPCRouteSpecFluent.this.setToRules(index,builder.build());
    }
    
    public N endRule() {
      return and();
    }
    
  
  }

}