package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRequestMirrorFilterFluent<A extends HTTPRequestMirrorFilterFluent<A>> extends BaseFluent<A>{
  public HTTPRequestMirrorFilterFluent() {
  }
  
  public HTTPRequestMirrorFilterFluent(HTTPRequestMirrorFilter instance) {
    this.copyInstance(instance);
  }
  private BackendObjectReferenceBuilder backendRef;
  private FractionBuilder fraction;
  private Integer percent;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRequestMirrorFilter instance) {
    instance = (instance != null ? instance : new HTTPRequestMirrorFilter());
    if (instance != null) {
          this.withBackendRef(instance.getBackendRef());
          this.withFraction(instance.getFraction());
          this.withPercent(instance.getPercent());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BackendObjectReference buildBackendRef() {
    return this.backendRef != null ? this.backendRef.build() : null;
  }
  
  public A withBackendRef(BackendObjectReference backendRef) {
    this._visitables.remove("backendRef");
    if (backendRef != null) {
        this.backendRef = new BackendObjectReferenceBuilder(backendRef);
        this._visitables.get("backendRef").add(this.backendRef);
    } else {
        this.backendRef = null;
        this._visitables.get("backendRef").remove(this.backendRef);
    }
    return (A) this;
  }
  
  public boolean hasBackendRef() {
    return this.backendRef != null;
  }
  
  public A withNewBackendRef(String group,String kind,String name,String namespace,Integer port) {
    return (A)withBackendRef(new BackendObjectReference(group, kind, name, namespace, port));
  }
  
  public BackendRefNested<A> withNewBackendRef() {
    return new BackendRefNested(null);
  }
  
  public BackendRefNested<A> withNewBackendRefLike(BackendObjectReference item) {
    return new BackendRefNested(item);
  }
  
  public BackendRefNested<A> editBackendRef() {
    return withNewBackendRefLike(java.util.Optional.ofNullable(buildBackendRef()).orElse(null));
  }
  
  public BackendRefNested<A> editOrNewBackendRef() {
    return withNewBackendRefLike(java.util.Optional.ofNullable(buildBackendRef()).orElse(new BackendObjectReferenceBuilder().build()));
  }
  
  public BackendRefNested<A> editOrNewBackendRefLike(BackendObjectReference item) {
    return withNewBackendRefLike(java.util.Optional.ofNullable(buildBackendRef()).orElse(item));
  }
  
  public Fraction buildFraction() {
    return this.fraction != null ? this.fraction.build() : null;
  }
  
  public A withFraction(Fraction fraction) {
    this._visitables.remove("fraction");
    if (fraction != null) {
        this.fraction = new FractionBuilder(fraction);
        this._visitables.get("fraction").add(this.fraction);
    } else {
        this.fraction = null;
        this._visitables.get("fraction").remove(this.fraction);
    }
    return (A) this;
  }
  
  public boolean hasFraction() {
    return this.fraction != null;
  }
  
  public A withNewFraction(Integer denominator,Integer numerator) {
    return (A)withFraction(new Fraction(denominator, numerator));
  }
  
  public FractionNested<A> withNewFraction() {
    return new FractionNested(null);
  }
  
  public FractionNested<A> withNewFractionLike(Fraction item) {
    return new FractionNested(item);
  }
  
  public FractionNested<A> editFraction() {
    return withNewFractionLike(java.util.Optional.ofNullable(buildFraction()).orElse(null));
  }
  
  public FractionNested<A> editOrNewFraction() {
    return withNewFractionLike(java.util.Optional.ofNullable(buildFraction()).orElse(new FractionBuilder().build()));
  }
  
  public FractionNested<A> editOrNewFractionLike(Fraction item) {
    return withNewFractionLike(java.util.Optional.ofNullable(buildFraction()).orElse(item));
  }
  
  public Integer getPercent() {
    return this.percent;
  }
  
  public A withPercent(Integer percent) {
    this.percent = percent;
    return (A) this;
  }
  
  public boolean hasPercent() {
    return this.percent != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRequestMirrorFilterFluent that = (HTTPRequestMirrorFilterFluent) o;
    if (!java.util.Objects.equals(backendRef, that.backendRef)) return false;
    if (!java.util.Objects.equals(fraction, that.fraction)) return false;
    if (!java.util.Objects.equals(percent, that.percent)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(backendRef,  fraction,  percent,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backendRef != null) { sb.append("backendRef:"); sb.append(backendRef + ","); }
    if (fraction != null) { sb.append("fraction:"); sb.append(fraction + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BackendRefNested<N> extends BackendObjectReferenceFluent<BackendRefNested<N>> implements Nested<N>{
    BackendRefNested(BackendObjectReference item) {
      this.builder = new BackendObjectReferenceBuilder(this, item);
    }
    BackendObjectReferenceBuilder builder;
    
    public N and() {
      return (N) HTTPRequestMirrorFilterFluent.this.withBackendRef(builder.build());
    }
    
    public N endBackendRef() {
      return and();
    }
    
  
  }
  public class FractionNested<N> extends FractionFluent<FractionNested<N>> implements Nested<N>{
    FractionNested(Fraction item) {
      this.builder = new FractionBuilder(this, item);
    }
    FractionBuilder builder;
    
    public N and() {
      return (N) HTTPRequestMirrorFilterFluent.this.withFraction(builder.build());
    }
    
    public N endFraction() {
      return and();
    }
    
  
  }

}