/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CommonRouteSpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CommonRouteSpecFluent<A extends CommonRouteSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public CommonRouteSpecFluent() {
    }

    public CommonRouteSpecFluent(CommonRouteSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CommonRouteSpec instance) {
        CommonRouteSpec commonRouteSpec = instance = instance != null ? instance : new CommonRouteSpec();
        if (instance != null) {
            this.withParentRefs(instance.getParentRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").remove((Object)builder);
            this.parentRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").remove((Object)builder);
            this.parentRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        Iterator<ParentReferenceBuilder> each = this.parentRefs.iterator();
        List visitables = this._visitables.get((Object)"parentRefs");
        while (each.hasNext()) {
            ParentReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ParentReference> buildParentRefs() {
        return this.parentRefs != null ? CommonRouteSpecFluent.build(this.parentRefs) : null;
    }

    public ParentReference buildParentRef(int index) {
        return this.parentRefs.get(index).build();
    }

    public ParentReference buildFirstParentRef() {
        return this.parentRefs.get(0).build();
    }

    public ParentReference buildLastParentRef() {
        return this.parentRefs.get(this.parentRefs.size() - 1).build();
    }

    public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParentRefs(List<ParentReference> parentRefs) {
        if (this.parentRefs != null) {
            this._visitables.get((Object)"parentRefs").clear();
        }
        if (parentRefs != null) {
            this.parentRefs = new ArrayList();
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        } else {
            this.parentRefs = null;
        }
        return (A)((Object)this);
    }

    public A withParentRefs(ParentReference ... parentRefs) {
        if (this.parentRefs != null) {
            this.parentRefs.clear();
            this._visitables.remove((Object)"parentRefs");
        }
        if (parentRefs != null) {
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParentRefs() {
        return this.parentRefs != null && !this.parentRefs.isEmpty();
    }

    public ParentRefsNested<A> addNewParentRef() {
        return new ParentRefsNested(-1, null);
    }

    public ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
        return new ParentRefsNested(-1, item);
    }

    public ParentRefsNested<A> setNewParentRefLike(int index, ParentReference item) {
        return new ParentRefsNested(index, item);
    }

    public ParentRefsNested<A> editParentRef(int index) {
        if (this.parentRefs.size() <= index) {
            throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public ParentRefsNested<A> editFirstParentRef() {
        if (this.parentRefs.size() == 0) {
            throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(0, this.buildParentRef(0));
    }

    public ParentRefsNested<A> editLastParentRef() {
        int index = this.parentRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parentRefs.size(); ++i) {
            if (!predicate.test(this.parentRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parentRefs. No match found.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommonRouteSpecFluent that = (CommonRouteSpecFluent)((Object)o);
        if (!Objects.equals(this.parentRefs, that.parentRefs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.parentRefs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parentRefs != null && !this.parentRefs.isEmpty()) {
            sb.append("parentRefs:");
            sb.append(String.valueOf(this.parentRefs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParentRefsNested<N>
    extends ParentReferenceFluent<ParentRefsNested<N>>
    implements Nested<N> {
        ParentReferenceBuilder builder;
        int index;

        ParentRefsNested(int index, ParentReference item) {
            this.index = index;
            this.builder = new ParentReferenceBuilder(this, item);
        }

        public N and() {
            return (N)CommonRouteSpecFluent.this.setToParentRefs(this.index, this.builder.build());
        }

        public N endParentRef() {
            return this.and();
        }
    }
}

