/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.util.NameHelper;

public class Fabric8NameHelper
extends NameHelper {
    private static final Pattern SINGLE_LETTER_DASH_NAME = Pattern.compile("^([a-z])-([a-zA-Z])(.*)$");

    public Fabric8NameHelper(GenerationConfig generationConfig) {
        super(generationConfig);
    }

    public String getGetterName(String propertyName, JType type, JsonNode node) {
        Matcher m = SINGLE_LETTER_DASH_NAME.matcher(propertyName);
        String getterName = super.getGetterName(propertyName, type, node);
        if (m.matches()) {
            return "get" + getterName.substring(3, 4).toUpperCase() + getterName.substring(4);
        }
        return getterName;
    }

    public String getSetterName(String propertyName, JsonNode node) {
        Matcher m = SINGLE_LETTER_DASH_NAME.matcher(propertyName);
        String setterName = super.getSetterName(propertyName, node);
        if (m.matches()) {
            return "set" + setterName.substring(3, 4).toUpperCase() + setterName.substring(4);
        }
        return setterName;
    }
}

