/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.fabric8.kubernetes.model.jackson.JsonUnwrappedDeserializer;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.TemplateTransformation;
import io.sundr.transform.annotations.TemplateTransformations;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;

public class KubernetesCoreTypeAnnotator
extends Jackson2Annotator {
    private static final String BUILDER_PACKAGE = "io.fabric8.kubernetes.api.builder";
    public static final String BUILDABLE_REFERENCE_VALUE = "value";
    protected static final String ANNOTATION_VALUE = "value";
    protected static final String API_VERSION = "apiVersion";
    protected static final String METADATA = "metadata";
    protected static final String KIND = "kind";
    protected static final String DEFAULT = "default";
    protected static final String INTERFACE_TYPE_PROPERTY = "interfaceType";
    private static final Set<String> IGNORED_CLASSES = ConcurrentHashMap.newKeySet();
    protected final Map<String, JDefinedClass> pendingResources = new HashMap<String, JDefinedClass>();
    protected final Map<String, JDefinedClass> pendingLists = new HashMap<String, JDefinedClass>();
    private final Set<String> handledClasses = new HashSet<String>();

    public KubernetesCoreTypeAnnotator(GenerationConfig generationConfig) {
        super(generationConfig);
    }

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        if (this.handledClasses.contains(clazz.fullName()) || IGNORED_CLASSES.contains(clazz.fullName())) {
            return;
        }
        this.handledClasses.add(clazz.fullName());
        JAnnotationArrayMember jsonPropertyOrder = clazz.annotate(JsonPropertyOrder.class).paramArray("value");
        List fieldNames = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertiesNode.fieldNames(), 16), false).collect(Collectors.toList());
        List<String> topFields = Arrays.asList(API_VERSION, KIND, METADATA);
        for (String topField : topFields) {
            if (!fieldNames.contains(topField)) continue;
            jsonPropertyOrder.param(topField);
        }
        fieldNames.stream().filter(f -> !topFields.contains(f)).forEach(arg_0 -> ((JAnnotationArrayMember)jsonPropertyOrder).param(arg_0));
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        clazz.annotate(Setter.class);
        clazz.annotate(Accessors.class).paramArray("prefix").param("_").param("");
        this.makeEditable(clazz);
        this.processBuildable(clazz);
        Map fields = clazz.fields();
        if (fields.containsKey(KIND) && propertiesNode.has(API_VERSION) && propertiesNode.get(API_VERSION).has(DEFAULT)) {
            String apiVersion = propertiesNode.get(API_VERSION).get(DEFAULT).toString().replace('\"', ' ').trim();
            String apiGroup = "";
            int lastSlash = apiVersion.lastIndexOf(47);
            if (lastSlash > 0) {
                apiGroup = apiVersion.substring(0, lastSlash);
                apiVersion = apiVersion.substring(apiGroup.length() + 1);
            }
            JAnnotationArrayMember arrayMember = clazz.annotate(TemplateTransformations.class).paramArray("value");
            arrayMember.annotate(TemplateTransformation.class).param("value", "/manifest.vm").param("outputPath", "META-INF/services/io.fabric8.kubernetes.api.model.KubernetesResource").param("gather", true);
            String resourceName = clazz.fullName();
            if (resourceName.endsWith("List")) {
                JDefinedClass resourceClass = this.pendingResources.remove(resourceName = resourceName.substring(0, resourceName.length() - 4));
                if (resourceClass != null) {
                    this.annotate(clazz, apiVersion, apiGroup);
                } else {
                    this.pendingLists.put(resourceName, clazz);
                }
            } else {
                JDefinedClass resourceListClass = this.pendingLists.remove(resourceName);
                if (resourceListClass != null) {
                    this.annotate(resourceListClass, apiVersion, apiGroup);
                } else {
                    this.annotate(clazz, apiVersion, apiGroup);
                    this.pendingResources.put(resourceName, clazz);
                }
            }
        }
    }

    private void makeEditable(JDefinedClass clazz) {
        JClass builderType = clazz.owner().ref(clazz.fullName() + "Builder");
        JClass editableType = clazz.owner().ref(Editable.class).narrow(builderType);
        clazz._implements(editableType);
        JMethod editMethod = clazz.method(1, (JType)builderType, "edit");
        editMethod.annotate(JsonIgnore.class);
        JInvocation newBuilder = JExpr._new((JClass)builderType).arg(JExpr._this());
        editMethod.body()._return((JExpression)newBuilder);
        JMethod toBuilderMethod = clazz.method(1, (JType)builderType, "toBuilder");
        toBuilderMethod.annotate(JsonIgnore.class);
        toBuilderMethod.body()._return((JExpression)JExpr.invoke((String)"edit"));
    }

    private void annotate(JDefinedClass clazz, String apiVersion, String apiGroup) {
        clazz.annotate(Version.class).param("value", apiVersion);
        clazz.annotate(Group.class).param("value", apiGroup);
    }

    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
        if (IGNORED_CLASSES.contains(clazz.fullName())) {
            return;
        }
        if (schema.has("serializer")) {
            this.annotateSerde(clazz, JsonSerialize.class, schema.get("serializer").asText());
        }
        String deserializer = null;
        if (schema.has("deserializer")) {
            deserializer = schema.get("deserializer").asText();
        }
        if (schema.has("properties") && this.hasInterfaceFields(schema.get("properties"))) {
            clazz.annotate(JsonDeserialize.class).param("using", JsonUnwrappedDeserializer.class);
        } else {
            this.annotateSerde(clazz, JsonDeserialize.class, deserializer == null ? JsonDeserializer.None.class.getCanonicalName() : deserializer);
        }
        super.propertyInclusion(clazz, schema);
    }

    private void annotateSerde(JDefinedClass clazz, Class<? extends Annotation> annotation, String usingClassName) {
        if (!usingClassName.endsWith(".class")) {
            usingClassName = usingClassName + ".class";
        }
        clazz.annotate(annotation).param("using", (JExpression)this.literalExpression(usingClassName));
    }

    private JExpressionImpl literalExpression(final String literal) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p(literal);
            }
        };
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        if (IGNORED_CLASSES.contains(clazz.fullName())) {
            return;
        }
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.has("javaOmitEmpty") && propertyNode.get("javaOmitEmpty").asBoolean(false)) {
            field.annotate(JsonInclude.class).param("value", (Enum)JsonInclude.Include.NON_EMPTY);
        }
        if (propertyNode.hasNonNull(INTERFACE_TYPE_PROPERTY)) {
            field.annotate(JsonUnwrapped.class);
        }
    }

    public void propertyGetter(JMethod getter, JDefinedClass clazz, String propertyName) {
        super.propertyGetter(getter, clazz, propertyName);
        JFieldVar field = (JFieldVar)clazz.fields().get(propertyName);
        if (field != null) {
            for (JAnnotationUse annotation : field.annotations()) {
                if (annotation.getAnnotationClass().fullName().equals(JsonInclude.class.getName())) {
                    JAnnotationUse methodAnnotation = getter.annotate(JsonInclude.class);
                    annotation.getAnnotationMembers().forEach((key, value) -> {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintWriter pw = new PrintWriter(new BufferedOutputStream(baos));
                        value.generate(new JFormatter(pw));
                        pw.flush();
                        methodAnnotation.param(key, (Enum)Enum.valueOf(JsonInclude.Include.class, baos.toString().replace(JsonInclude.Include.class.getCanonicalName() + ".", "")));
                    });
                }
                if (!annotation.getAnnotationClass().fullName().equals(JsonUnwrapped.class.getName())) continue;
                getter.annotate(JsonUnwrapped.class);
            }
        }
    }

    protected void processBuildable(JDefinedClass clazz) {
        JAnnotationUse buildable = clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", false).param("generateBuilderPackage", this.generateBuilderPackage()).param("lazyCollectionInitEnabled", false).param("builderPackage", BUILDER_PACKAGE);
        ArrayList<String> types = new ArrayList<String>();
        this.addBuildableTypes(clazz, types);
        if (!types.isEmpty()) {
            JAnnotationArrayMember arrayMember = buildable.paramArray("refs");
            types.stream().forEach(s -> {
                try {
                    arrayMember.annotate(BuildableReference.class).param("value", (JType)new JCodeModel()._class(s));
                }
                catch (JClassAlreadyExistsException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    protected boolean generateBuilderPackage() {
        return false;
    }

    protected void addBuildableTypes(JDefinedClass clazz, List<String> types) {
    }

    private boolean hasInterfaceFields(JsonNode propertiesNode) {
        Iterator field = propertiesNode.elements();
        while (field.hasNext()) {
            JsonNode propertyNode = (JsonNode)field.next();
            if (!propertyNode.hasNonNull(INTERFACE_TYPE_PROPERTY)) continue;
            return true;
        }
        return false;
    }

    static {
        IGNORED_CLASSES.add("io.fabric8.kubernetes.api.model.KubeSchema");
        IGNORED_CLASSES.add("io.fabric8.kubernetes.api.model.ValidationSchema");
    }
}

