/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.AdditionalPropertiesRule;
import org.jsonschema2pojo.rules.RuleFactory;

public class Fabric8AdditionalPropertiesRule
extends AdditionalPropertiesRule {
    public Fabric8AdditionalPropertiesRule(RuleFactory ruleFactory) {
        super(ruleFactory);
    }

    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass jclass, Schema schema) {
        super.apply(nodeName, node, parent, jclass, schema);
        JFieldVar additionalPropertiesField = (JFieldVar)jclass.fields().get("additionalProperties");
        if (additionalPropertiesField == null || !additionalPropertiesField.type().name().equals("Map<String,Object>")) {
            return jclass;
        }
        JMethod setter = jclass.method(1, Void.TYPE, "setAdditionalProperties");
        JVar param = setter.param(additionalPropertiesField.type(), additionalPropertiesField.name());
        JBlock body = setter.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)additionalPropertiesField), (JExpression)param);
        return jclass;
    }
}

