/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.DefaultRule;
import org.jsonschema2pojo.rules.RuleFactory;

public class Fabric8DefaultRule
extends DefaultRule {
    private final RuleFactory ruleFactory;

    public Fabric8DefaultRule(RuleFactory ruleFactory) {
        super(ruleFactory);
        this.ruleFactory = ruleFactory;
    }

    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        super.apply(nodeName, node, parent, field, currentSchema);
        JType fieldType = field.type();
        String fieldTypeName = field.type().fullName();
        if (this.ruleFactory.getGenerationConfig().isInitializeCollections()) {
            if (fieldTypeName.startsWith(Map.class.getName()) && (node == null || node.asText() == null || node.asText().isEmpty())) {
                JClass mapImplClass = fieldType.owner().ref(LinkedHashMap.class).narrow(Collections.emptyList());
                field.init((JExpression)JExpr._new((JClass)mapImplClass));
            } else if (fieldTypeName.startsWith(List.class.getName())) {
                JClass listImplClass = fieldType.owner().ref(ArrayList.class).narrow(Collections.emptyList());
                field.init((JExpression)JExpr._new((JClass)listImplClass));
            } else if (fieldTypeName.startsWith(Set.class.getName())) {
                JClass setImplClass = fieldType.owner().ref(HashSet.class).narrow(Collections.emptyList());
                field.init((JExpression)JExpr._new((JClass)setImplClass));
            }
        }
        return field;
    }
}

