package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class NodeMetricsFluentImpl<A extends NodeMetricsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeMetricsFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Map<String,Quantity> usage;
    private Duration window;

    public NodeMetricsFluentImpl() { 
    }


    public NodeMetricsFluentImpl(NodeMetrics instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withTimestamp(instance.getTimestamp()); 
        this.withUsage(instance.getUsage()); 
        this.withWindow(instance.getWindow()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public NodeMetricsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public NodeMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public NodeMetricsFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public A withTimestamp(String timestamp) {
        this.timestamp=timestamp; return (A) this;
    }

    public Boolean hasTimestamp() {
        return this.timestamp != null;
    }

    public A withNewTimestamp(String arg1) {
        return (A)withTimestamp(new String(arg1));
    }

    public A withNewTimestamp(StringBuilder arg1) {
        return (A)withTimestamp(new String(arg1));
    }

    public A withNewTimestamp(StringBuffer arg1) {
        return (A)withTimestamp(new String(arg1));
    }

    public A addToUsage(String key,Quantity value) {
        if(this.usage == null && key != null && value != null) { this.usage = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.usage.put(key, value);} return (A)this;
    }

    public A addToUsage(Map<String,Quantity> map) {
        if(this.usage == null && map != null) { this.usage = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.usage.putAll(map);} return (A)this;
    }

    public A removeFromUsage(String key) {
        if(this.usage == null) { return (A) this; }
        if(key != null && this.usage != null) {this.usage.remove(key);} return (A)this;
    }

    public A removeFromUsage(Map<String,Quantity> map) {
        if(this.usage == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.usage != null){this.usage.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getUsage() {
        return this.usage;
    }

    public A withUsage(Map<String,Quantity> usage) {
        if (usage == null) { this.usage =  null;} else {this.usage = new LinkedHashMap<String,Quantity>(usage);} return (A) this;
    }

    public Boolean hasUsage() {
        return this.usage != null;
    }

    public Duration getWindow() {
        return this.window;
    }

    public A withWindow(Duration window) {
        this.window=window; return (A) this;
    }

    public Boolean hasWindow() {
        return this.window != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodeMetricsFluentImpl that = (NodeMetricsFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
        if (usage != null ? !usage.equals(that.usage) :that.usage != null) return false;
        if (window != null ? !window.equals(that.window) :that.window != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  timestamp,  usage,  window,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<NodeMetricsFluent.MetadataNested<N>> implements NodeMetricsFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) NodeMetricsFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


}
