package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMetricsBuilder extends io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluentImpl<io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics,io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsBuilder> {

    io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodMetricsBuilder() {
        this(true);
    }

    public PodMetricsBuilder(java.lang.Boolean validationEnabled) {
        this(new PodMetrics(), validationEnabled);
    }

    public PodMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodMetrics(), validationEnabled);
    }

    public PodMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<?> fluent,io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics instance) {
        this(fluent, instance, true);
    }

    public PodMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<?> fluent,io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withContainers(instance.getContainers()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withTimestamp(instance.getTimestamp()); 
        fluent.withWindow(instance.getWindow()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics instance) {
        this(instance,true);
    }

    public PodMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withContainers(instance.getContainers()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withTimestamp(instance.getTimestamp()); 
        this.withWindow(instance.getWindow()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics build() {
        PodMetrics buildable = new PodMetrics(fluent.getApiVersion(),fluent.getContainers(),fluent.getKind(),fluent.getMetadata(),fluent.getTimestamp(),fluent.getWindow());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMetricsBuilder that = (PodMetricsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
