package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeMetricsBuilder extends NodeMetricsFluent<NodeMetricsBuilder> implements VisitableBuilder<NodeMetrics,NodeMetricsBuilder>{
  public NodeMetricsBuilder() {
    this(new NodeMetrics());
  }
  
  public NodeMetricsBuilder(NodeMetricsFluent<?> fluent) {
    this(fluent, new NodeMetrics());
  }
  
  public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,NodeMetrics instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeMetricsBuilder(NodeMetrics instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeMetricsFluent<?> fluent;
  
  public NodeMetrics build() {
    NodeMetrics buildable = new NodeMetrics(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.getTimestamp(),fluent.getUsage(),fluent.getWindow());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}