/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluentImpl;
import java.util.Objects;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>>
extends BaseFluent<A>
implements IngressBackendFluent<A> {
    private TypedLocalObjectReference resource;
    private IngressServiceBackendBuilder service;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withResource(instance.getResource());
        this.withService(instance.getService());
    }

    @Override
    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    @Override
    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    @Deprecated
    public IngressServiceBackend getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public IngressServiceBackend buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(IngressServiceBackend service) {
        this._visitables.get((Object)"service").remove(this.service);
        if (service != null) {
            this.service = new IngressServiceBackendBuilder(service);
            this._visitables.get((Object)"service").add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new IngressServiceBackendBuilder().build());
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.resource != null ? !this.resource.equals((Object)that.resource) : that.resource != null) {
            return false;
        }
        return !(this.service != null ? !this.service.equals(that.service) : that.service != null);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.service, super.hashCode());
    }

    public class ServiceNestedImpl<N>
    extends IngressServiceBackendFluentImpl<IngressBackendFluent.ServiceNested<N>>
    implements IngressBackendFluent.ServiceNested<N>,
    Nested<N> {
        IngressServiceBackendBuilder builder;

        ServiceNestedImpl(IngressServiceBackend item) {
            this.builder = new IngressServiceBackendBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new IngressServiceBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

