package io.fabric8.kubernetes.api.model.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressClassSpecFluent<A extends IngressClassSpecFluent<A>> extends BaseFluent<A>{
  public IngressClassSpecFluent() {
  }
  
  public IngressClassSpecFluent(IngressClassSpec instance) {
    this.copyInstance(instance);
  }
  private String controller;
  private IngressClassParametersReferenceBuilder parameters;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressClassSpec instance) {
    instance = (instance != null ? instance : new IngressClassSpec());
    if (instance != null) {
          this.withController(instance.getController());
          this.withParameters(instance.getParameters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getController() {
    return this.controller;
  }
  
  public A withController(String controller) {
    this.controller = controller;
    return (A) this;
  }
  
  public boolean hasController() {
    return this.controller != null;
  }
  
  public IngressClassParametersReference buildParameters() {
    return this.parameters != null ? this.parameters.build() : null;
  }
  
  public A withParameters(IngressClassParametersReference parameters) {
    this._visitables.remove("parameters");
    if (parameters != null) {
        this.parameters = new IngressClassParametersReferenceBuilder(parameters);
        this._visitables.get("parameters").add(this.parameters);
    } else {
        this.parameters = null;
        this._visitables.get("parameters").remove(this.parameters);
    }
    return (A) this;
  }
  
  public boolean hasParameters() {
    return this.parameters != null;
  }
  
  public A withNewParameters(String apiGroup,String kind,String name,String namespace,String scope) {
    return (A)withParameters(new IngressClassParametersReference(apiGroup, kind, name, namespace, scope));
  }
  
  public ParametersNested<A> withNewParameters() {
    return new ParametersNested(null);
  }
  
  public ParametersNested<A> withNewParametersLike(IngressClassParametersReference item) {
    return new ParametersNested(item);
  }
  
  public ParametersNested<A> editParameters() {
    return withNewParametersLike(java.util.Optional.ofNullable(buildParameters()).orElse(null));
  }
  
  public ParametersNested<A> editOrNewParameters() {
    return withNewParametersLike(java.util.Optional.ofNullable(buildParameters()).orElse(new IngressClassParametersReferenceBuilder().build()));
  }
  
  public ParametersNested<A> editOrNewParametersLike(IngressClassParametersReference item) {
    return withNewParametersLike(java.util.Optional.ofNullable(buildParameters()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressClassSpecFluent that = (IngressClassSpecFluent) o;
    if (!java.util.Objects.equals(controller, that.controller)) return false;
    if (!java.util.Objects.equals(parameters, that.parameters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(controller,  parameters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controller != null) { sb.append("controller:"); sb.append(controller + ","); }
    if (parameters != null) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ParametersNested<N> extends IngressClassParametersReferenceFluent<ParametersNested<N>> implements Nested<N>{
    ParametersNested(IngressClassParametersReference item) {
      this.builder = new IngressClassParametersReferenceBuilder(this, item);
    }
    IngressClassParametersReferenceBuilder builder;
    
    public N and() {
      return (N) IngressClassSpecFluent.this.withParameters(builder.build());
    }
    
    public N endParameters() {
      return and();
    }
    
  
  }

}