package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkPolicyIngressRuleBuilder extends NetworkPolicyIngressRuleFluent<NetworkPolicyIngressRuleBuilder> implements VisitableBuilder<NetworkPolicyIngressRule,NetworkPolicyIngressRuleBuilder>{
  public NetworkPolicyIngressRuleBuilder() {
    this(new NetworkPolicyIngressRule());
  }
  
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent) {
    this(fluent, new NetworkPolicyIngressRule());
  }
  
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent,NetworkPolicyIngressRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkPolicyIngressRuleFluent<?> fluent;
  
  public NetworkPolicyIngressRule build() {
    NetworkPolicyIngressRule buildable = new NetworkPolicyIngressRule(fluent.buildFrom(),fluent.buildPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}