package io.fabric8.kubernetes.api.model.networking.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressServiceBackendFluentImpl<A extends IngressServiceBackendFluent<A>> extends BaseFluent<A> implements IngressServiceBackendFluent<A>{
  public IngressServiceBackendFluentImpl() {
  }
  public IngressServiceBackendFluentImpl(IngressServiceBackend instance) {
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String name;
  private ServiceBackendPortBuilder port;
  private Map<String,Object> additionalProperties;
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBackendPort getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public ServiceBackendPort buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(ServiceBackendPort port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new ServiceBackendPortBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(String name,Integer number) {
    return (A)withPort(new ServiceBackendPort(name, number));
  }
  public IngressServiceBackendFluent.PortNested<A> withNewPort() {
    return new IngressServiceBackendFluentImpl.PortNestedImpl();
  }
  public IngressServiceBackendFluent.PortNested<A> withNewPortLike(ServiceBackendPort item) {
    return new IngressServiceBackendFluentImpl.PortNestedImpl(item);
  }
  public IngressServiceBackendFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public IngressServiceBackendFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new ServiceBackendPortBuilder().build());
  }
  public IngressServiceBackendFluent.PortNested<A> editOrNewPortLike(ServiceBackendPort item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressServiceBackendFluentImpl that = (IngressServiceBackendFluentImpl) o;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  port,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends ServiceBackendPortFluentImpl<IngressServiceBackendFluent.PortNested<N>> implements IngressServiceBackendFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(ServiceBackendPort item) {
      this.builder = new ServiceBackendPortBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new ServiceBackendPortBuilder(this);
    }
    ServiceBackendPortBuilder builder;
    public N and() {
      return (N) IngressServiceBackendFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}