package io.fabric8.kubernetes.api.model.networking.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface IngressBackendFluent<A extends IngressBackendFluent<A>> extends Fluent<A>{
  public TypedLocalObjectReference getResource();
  public A withResource(TypedLocalObjectReference resource);
  public Boolean hasResource();
  public A withNewResource(String apiGroup,String kind,String name);
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressServiceBackend getService();
  public IngressServiceBackend buildService();
  public A withService(IngressServiceBackend service);
  public Boolean hasService();
  public IngressBackendFluent.ServiceNested<A> withNewService();
  public IngressBackendFluent.ServiceNested<A> withNewServiceLike(IngressServiceBackend item);
  public IngressBackendFluent.ServiceNested<A> editService();
  public IngressBackendFluent.ServiceNested<A> editOrNewService();
  public IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ServiceNested<N> extends Nested<N>,IngressServiceBackendFluent<IngressBackendFluent.ServiceNested<N>>{
    public N and();
    public N endService();
    
  }
  
}