package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressClassListBuilder extends IngressClassListFluentImpl<IngressClassListBuilder> implements VisitableBuilder<IngressClassList,IngressClassListBuilder>{
  public IngressClassListBuilder() {
    this(false);
  }
  public IngressClassListBuilder(Boolean validationEnabled) {
    this(new IngressClassList(), validationEnabled);
  }
  public IngressClassListBuilder(IngressClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressClassListBuilder(IngressClassListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressClassList(), validationEnabled);
  }
  public IngressClassListBuilder(IngressClassListFluent<?> fluent,IngressClassList instance) {
    this(fluent, instance, false);
  }
  public IngressClassListBuilder(IngressClassListFluent<?> fluent,IngressClassList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressClassListBuilder(IngressClassList instance) {
    this(instance,false);
  }
  public IngressClassListBuilder(IngressClassList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressClassListFluent<?> fluent;
  Boolean validationEnabled;
  public IngressClassList build() {
    IngressClassList buildable = new IngressClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}