package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressRuleBuilder extends IngressRuleFluentImpl<IngressRuleBuilder> implements VisitableBuilder<IngressRule,IngressRuleBuilder>{
  public IngressRuleBuilder() {
    this(false);
  }
  public IngressRuleBuilder(Boolean validationEnabled) {
    this(new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,IngressRule instance) {
    this(fluent, instance, false);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,IngressRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withHttp(instance.getHttp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressRuleBuilder(IngressRule instance) {
    this(instance,false);
  }
  public IngressRuleBuilder(IngressRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHost(instance.getHost());
      this.withHttp(instance.getHttp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressRuleFluent<?> fluent;
  Boolean validationEnabled;
  public IngressRule build() {
    IngressRule buildable = new IngressRule(fluent.getHost(),fluent.getHttp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}