package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyIngressRuleBuilder extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicyIngressRuleBuilder> implements VisitableBuilder<NetworkPolicyIngressRule,NetworkPolicyIngressRuleBuilder>{
  public NetworkPolicyIngressRuleBuilder() {
    this(false);
  }
  public NetworkPolicyIngressRuleBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyIngressRule(), validationEnabled);
  }
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicyIngressRule(), validationEnabled);
  }
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent,NetworkPolicyIngressRule instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent,NetworkPolicyIngressRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFrom(instance.getFrom());
      fluent.withPorts(instance.getPorts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRule instance) {
    this(instance,false);
  }
  public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyIngressRuleFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicyIngressRule build() {
    NetworkPolicyIngressRule buildable = new NetworkPolicyIngressRule(fluent.getFrom(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}