package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyPortBuilder extends NetworkPolicyPortFluentImpl<NetworkPolicyPortBuilder> implements VisitableBuilder<NetworkPolicyPort,NetworkPolicyPortBuilder>{
  public NetworkPolicyPortBuilder() {
    this(false);
  }
  public NetworkPolicyPortBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyPort(), validationEnabled);
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicyPort(), validationEnabled);
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent,NetworkPolicyPort instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent,NetworkPolicyPort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEndPort(instance.getEndPort());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPort instance) {
    this(instance,false);
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPort instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEndPort(instance.getEndPort());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyPortFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicyPort build() {
    NetworkPolicyPort buildable = new NetworkPolicyPort(fluent.getEndPort(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}