package io.fabric8.kubernetes.api.model.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPIngressPathFluentImpl<A extends HTTPIngressPathFluent<A>> extends BaseFluent<A> implements HTTPIngressPathFluent<A>{
  public HTTPIngressPathFluentImpl() {
  }
  public HTTPIngressPathFluentImpl(HTTPIngressPath instance) {
    if (instance != null) {
      this.withBackend(instance.getBackend());
      this.withPath(instance.getPath());
      this.withPathType(instance.getPathType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private IngressBackendBuilder backend;
  private String path;
  private String pathType;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildBackend instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressBackend getBackend() {
    return this.backend!=null ?this.backend.build():null;
  }
  public IngressBackend buildBackend() {
    return this.backend!=null ?this.backend.build():null;
  }
  public A withBackend(IngressBackend backend) {
    _visitables.get("backend").remove(this.backend);
    if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.get("backend").add(this.backend);} else { this.backend = null; _visitables.get("backend").remove(this.backend); } return (A) this;
  }
  public Boolean hasBackend() {
    return this.backend != null;
  }
  public HTTPIngressPathFluentImpl.BackendNested<A> withNewBackend() {
    return new HTTPIngressPathFluentImpl.BackendNestedImpl();
  }
  public HTTPIngressPathFluentImpl.BackendNested<A> withNewBackendLike(IngressBackend item) {
    return new HTTPIngressPathFluentImpl.BackendNestedImpl(item);
  }
  public HTTPIngressPathFluentImpl.BackendNested<A> editBackend() {
    return withNewBackendLike(getBackend());
  }
  public HTTPIngressPathFluentImpl.BackendNested<A> editOrNewBackend() {
    return withNewBackendLike(getBackend() != null ? getBackend(): new IngressBackendBuilder().build());
  }
  public HTTPIngressPathFluentImpl.BackendNested<A> editOrNewBackendLike(IngressBackend item) {
    return withNewBackendLike(getBackend() != null ? getBackend(): item);
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getPathType() {
    return this.pathType;
  }
  public A withPathType(String pathType) {
    this.pathType=pathType; return (A) this;
  }
  public Boolean hasPathType() {
    return this.pathType != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPIngressPathFluentImpl that = (HTTPIngressPathFluentImpl) o;
    if (!java.util.Objects.equals(backend, that.backend)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(pathType, that.pathType)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backend,  path,  pathType,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backend != null) { sb.append("backend:"); sb.append(backend + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (pathType != null) { sb.append("pathType:"); sb.append(pathType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BackendNestedImpl<N> extends IngressBackendFluentImpl<HTTPIngressPathFluentImpl.BackendNested<N>> implements HTTPIngressPathFluentImpl.BackendNested<N>,Nested<N>{
    BackendNestedImpl(IngressBackend item) {
      this.builder = new IngressBackendBuilder(this, item);
    }
    BackendNestedImpl() {
      this.builder = new IngressBackendBuilder(this);
    }
    IngressBackendBuilder builder;
    public N and() {
      return (N) HTTPIngressPathFluentImpl.this.withBackend(builder.build());
    }
    public N endBackend() {
      return and();
    }
    
  }
  
}