package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPIngressRuleValueBuilder extends HTTPIngressRuleValueFluentImpl<HTTPIngressRuleValueBuilder> implements VisitableBuilder<HTTPIngressRuleValue,HTTPIngressRuleValueBuilder>{
  public HTTPIngressRuleValueBuilder() {
    this(false);
  }
  public HTTPIngressRuleValueBuilder(Boolean validationEnabled) {
    this(new HTTPIngressRuleValue(), validationEnabled);
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPIngressRuleValue(), validationEnabled);
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent,HTTPIngressRuleValue instance) {
    this(fluent, instance, false);
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent,HTTPIngressRuleValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPaths(instance.getPaths());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValue instance) {
    this(instance,false);
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPaths(instance.getPaths());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPIngressRuleValueFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPIngressRuleValue build() {
    HTTPIngressRuleValue buildable = new HTTPIngressRuleValue(fluent.getPaths());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}