package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface IngressClassFluent<A extends IngressClassFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public IngressClassFluent.MetadataNested<A> withNewMetadata();
  public IngressClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public IngressClassFluent.MetadataNested<A> editMetadata();
  public IngressClassFluent.MetadataNested<A> editOrNewMetadata();
  public IngressClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressClassSpec getSpec();
  public IngressClassSpec buildSpec();
  public A withSpec(IngressClassSpec spec);
  public Boolean hasSpec();
  public IngressClassFluent.SpecNested<A> withNewSpec();
  public IngressClassFluent.SpecNested<A> withNewSpecLike(IngressClassSpec item);
  public IngressClassFluent.SpecNested<A> editSpec();
  public IngressClassFluent.SpecNested<A> editOrNewSpec();
  public IngressClassFluent.SpecNested<A> editOrNewSpecLike(IngressClassSpec item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<IngressClassFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,IngressClassSpecFluent<IngressClassFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  
}