package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressPortStatusBuilder extends IngressPortStatusFluentImpl<IngressPortStatusBuilder> implements VisitableBuilder<IngressPortStatus,IngressPortStatusBuilder>{
  public IngressPortStatusBuilder() {
    this(false);
  }
  public IngressPortStatusBuilder(Boolean validationEnabled) {
    this(new IngressPortStatus(), validationEnabled);
  }
  public IngressPortStatusBuilder(IngressPortStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressPortStatusBuilder(IngressPortStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressPortStatus(), validationEnabled);
  }
  public IngressPortStatusBuilder(IngressPortStatusFluent<?> fluent,IngressPortStatus instance) {
    this(fluent, instance, false);
  }
  public IngressPortStatusBuilder(IngressPortStatusFluent<?> fluent,IngressPortStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withError(instance.getError());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressPortStatusBuilder(IngressPortStatus instance) {
    this(instance,false);
  }
  public IngressPortStatusBuilder(IngressPortStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withError(instance.getError());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressPortStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IngressPortStatus build() {
    IngressPortStatus buildable = new IngressPortStatus(fluent.getError(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}