package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParentReferenceBuilder extends ParentReferenceFluent<ParentReferenceBuilder> implements VisitableBuilder<ParentReference,ParentReferenceBuilder>{
  public ParentReferenceBuilder() {
    this(false);
  }
  public ParentReferenceBuilder(Boolean validationEnabled) {
    this(new ParentReference(), validationEnabled);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParentReference(), validationEnabled);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,ParentReference instance) {
    this(fluent, instance, false);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,ParentReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ParentReference());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withUid(instance.getUid());
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParentReferenceBuilder(ParentReference instance) {
    this(instance,false);
  }
  public ParentReferenceBuilder(ParentReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ParentReference());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withUid(instance.getUid());
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParentReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ParentReference build() {
    ParentReference buildable = new ParentReference(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}