package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkPolicyPeerBuilder extends NetworkPolicyPeerFluent<NetworkPolicyPeerBuilder> implements VisitableBuilder<NetworkPolicyPeer,NetworkPolicyPeerBuilder>{
  public NetworkPolicyPeerBuilder() {
    this(new NetworkPolicyPeer());
  }
  
  public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent) {
    this(fluent, new NetworkPolicyPeer());
  }
  
  public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent,NetworkPolicyPeer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkPolicyPeerFluent<?> fluent;
  
  public NetworkPolicyPeer build() {
    NetworkPolicyPeer buildable = new NetworkPolicyPeer(fluent.buildIpBlock(),fluent.buildNamespaceSelector(),fluent.buildPodSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}