package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressTLSBuilder extends IngressTLSFluent<IngressTLSBuilder> implements VisitableBuilder<IngressTLS,IngressTLSBuilder>{
  public IngressTLSBuilder() {
    this(new IngressTLS());
  }
  
  public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
    this(fluent, new IngressTLS());
  }
  
  public IngressTLSBuilder(IngressTLSFluent<?> fluent,IngressTLS instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressTLSBuilder(IngressTLS instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressTLSFluent<?> fluent;
  
  public IngressTLS build() {
    IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}