package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressBackendBuilder extends IngressBackendFluent<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,IngressBackendBuilder>{
  public IngressBackendBuilder() {
    this(new IngressBackend());
  }
  
  public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
    this(fluent, new IngressBackend());
  }
  
  public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressBackendBuilder(IngressBackend instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressBackendFluent<?> fluent;
  
  public IngressBackend build() {
    IngressBackend buildable = new IngressBackend(fluent.getResource(),fluent.buildService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}