package io.fabric8.kubernetes.api.model.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressStatusFluent<A extends IngressStatusFluent<A>> extends BaseFluent<A>{
  public IngressStatusFluent() {
  }
  
  public IngressStatusFluent(IngressStatus instance) {
    this.copyInstance(instance);
  }
  private LoadBalancerStatus loadBalancer;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressStatus instance) {
    instance = (instance != null ? instance : new IngressStatus());
    if (instance != null) {
          this.withLoadBalancer(instance.getLoadBalancer());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LoadBalancerStatus getLoadBalancer() {
    return this.loadBalancer;
  }
  
  public A withLoadBalancer(LoadBalancerStatus loadBalancer) {
    this.loadBalancer = loadBalancer;
    return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressStatusFluent that = (IngressStatusFluent) o;
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(loadBalancer,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}