/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.node.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.node.v1beta1.Overhead;
import io.fabric8.kubernetes.api.model.node.v1beta1.OverheadBuilder;
import io.fabric8.kubernetes.api.model.node.v1beta1.OverheadFluentImpl;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClassFluent;
import io.fabric8.kubernetes.api.model.node.v1beta1.Scheduling;
import io.fabric8.kubernetes.api.model.node.v1beta1.SchedulingBuilder;
import io.fabric8.kubernetes.api.model.node.v1beta1.SchedulingFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RuntimeClassFluentImpl<A extends RuntimeClassFluent<A>>
extends BaseFluent<A>
implements RuntimeClassFluent<A> {
    private String apiVersion;
    private String handler;
    private String kind;
    private ObjectMetaBuilder metadata;
    private OverheadBuilder overhead;
    private SchedulingBuilder scheduling;
    private Map<String, Object> additionalProperties;

    public RuntimeClassFluentImpl() {
    }

    public RuntimeClassFluentImpl(RuntimeClass instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withHandler(instance.getHandler());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withOverhead(instance.getOverhead());
        this.withScheduling(instance.getScheduling());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public A withHandler(String handler) {
        this.handler = handler;
        return (A)this;
    }

    @Override
    public Boolean hasHandler() {
        return this.handler != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public RuntimeClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RuntimeClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RuntimeClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RuntimeClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public RuntimeClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public Overhead getOverhead() {
        return this.overhead != null ? this.overhead.build() : null;
    }

    @Override
    public Overhead buildOverhead() {
        return this.overhead != null ? this.overhead.build() : null;
    }

    @Override
    public A withOverhead(Overhead overhead) {
        this._visitables.get((Object)"overhead").remove(this.overhead);
        if (overhead != null) {
            this.overhead = new OverheadBuilder(overhead);
            this._visitables.get((Object)"overhead").add(this.overhead);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    @Override
    public RuntimeClassFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    @Override
    public RuntimeClassFluent.OverheadNested<A> withNewOverheadLike(Overhead item) {
        return new OverheadNestedImpl(item);
    }

    @Override
    public RuntimeClassFluent.OverheadNested<A> editOverhead() {
        return this.withNewOverheadLike(this.getOverhead());
    }

    @Override
    public RuntimeClassFluent.OverheadNested<A> editOrNewOverhead() {
        return this.withNewOverheadLike(this.getOverhead() != null ? this.getOverhead() : new OverheadBuilder().build());
    }

    @Override
    public RuntimeClassFluent.OverheadNested<A> editOrNewOverheadLike(Overhead item) {
        return this.withNewOverheadLike(this.getOverhead() != null ? this.getOverhead() : item);
    }

    @Override
    @Deprecated
    public Scheduling getScheduling() {
        return this.scheduling != null ? this.scheduling.build() : null;
    }

    @Override
    public Scheduling buildScheduling() {
        return this.scheduling != null ? this.scheduling.build() : null;
    }

    @Override
    public A withScheduling(Scheduling scheduling) {
        this._visitables.get((Object)"scheduling").remove(this.scheduling);
        if (scheduling != null) {
            this.scheduling = new SchedulingBuilder(scheduling);
            this._visitables.get((Object)"scheduling").add(this.scheduling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    @Override
    public RuntimeClassFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    @Override
    public RuntimeClassFluent.SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    @Override
    public RuntimeClassFluent.SchedulingNested<A> editScheduling() {
        return this.withNewSchedulingLike(this.getScheduling());
    }

    @Override
    public RuntimeClassFluent.SchedulingNested<A> editOrNewScheduling() {
        return this.withNewSchedulingLike(this.getScheduling() != null ? this.getScheduling() : new SchedulingBuilder().build());
    }

    @Override
    public RuntimeClassFluent.SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
        return this.withNewSchedulingLike(this.getScheduling() != null ? this.getScheduling() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeClassFluentImpl that = (RuntimeClassFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.overhead != null ? !this.overhead.equals(that.overhead) : that.overhead != null) {
            return false;
        }
        if (this.scheduling != null ? !this.scheduling.equals(that.scheduling) : that.scheduling != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.handler, this.kind, this.metadata, this.overhead, this.scheduling, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.handler != null) {
            sb.append("handler:");
            sb.append(this.handler + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.overhead != null) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.scheduling != null) {
            sb.append("scheduling:");
            sb.append(this.scheduling + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SchedulingNestedImpl<N>
    extends SchedulingFluentImpl<RuntimeClassFluent.SchedulingNested<N>>
    implements RuntimeClassFluent.SchedulingNested<N>,
    Nested<N> {
        SchedulingBuilder builder;

        SchedulingNestedImpl(Scheduling item) {
            this.builder = new SchedulingBuilder(this, item);
        }

        SchedulingNestedImpl() {
            this.builder = new SchedulingBuilder(this);
        }

        @Override
        public N and() {
            return (N)RuntimeClassFluentImpl.this.withScheduling(this.builder.build());
        }

        @Override
        public N endScheduling() {
            return this.and();
        }
    }

    class OverheadNestedImpl<N>
    extends OverheadFluentImpl<RuntimeClassFluent.OverheadNested<N>>
    implements RuntimeClassFluent.OverheadNested<N>,
    Nested<N> {
        OverheadBuilder builder;

        OverheadNestedImpl(Overhead item) {
            this.builder = new OverheadBuilder(this, item);
        }

        OverheadNestedImpl() {
            this.builder = new OverheadBuilder(this);
        }

        @Override
        public N and() {
            return (N)RuntimeClassFluentImpl.this.withOverhead(this.builder.build());
        }

        @Override
        public N endOverhead() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RuntimeClassFluent.MetadataNested<N>>
    implements RuntimeClassFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)RuntimeClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

