package io.fabric8.kubernetes.api.model.node.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RuntimeClassFluent<A extends RuntimeClassFluent<A>> extends BaseFluent<A>{
  public RuntimeClassFluent() {
  }
  
  public RuntimeClassFluent(RuntimeClass instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String handler;
  private String kind;
  private ObjectMetaBuilder metadata;
  private OverheadBuilder overhead;
  private SchedulingBuilder scheduling;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RuntimeClass instance) {
    instance = (instance != null ? instance : new RuntimeClass());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withHandler(instance.getHandler());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withOverhead(instance.getOverhead());
          this.withScheduling(instance.getScheduling());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getHandler() {
    return this.handler;
  }
  
  public A withHandler(String handler) {
    this.handler = handler;
    return (A) this;
  }
  
  public boolean hasHandler() {
    return this.handler != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public Overhead buildOverhead() {
    return this.overhead != null ? this.overhead.build() : null;
  }
  
  public A withOverhead(Overhead overhead) {
    this._visitables.remove("overhead");
    if (overhead != null) {
        this.overhead = new OverheadBuilder(overhead);
        this._visitables.get("overhead").add(this.overhead);
    } else {
        this.overhead = null;
        this._visitables.get("overhead").remove(this.overhead);
    }
    return (A) this;
  }
  
  public boolean hasOverhead() {
    return this.overhead != null;
  }
  
  public OverheadNested<A> withNewOverhead() {
    return new OverheadNested(null);
  }
  
  public OverheadNested<A> withNewOverheadLike(Overhead item) {
    return new OverheadNested(item);
  }
  
  public OverheadNested<A> editOverhead() {
    return withNewOverheadLike(java.util.Optional.ofNullable(buildOverhead()).orElse(null));
  }
  
  public OverheadNested<A> editOrNewOverhead() {
    return withNewOverheadLike(java.util.Optional.ofNullable(buildOverhead()).orElse(new OverheadBuilder().build()));
  }
  
  public OverheadNested<A> editOrNewOverheadLike(Overhead item) {
    return withNewOverheadLike(java.util.Optional.ofNullable(buildOverhead()).orElse(item));
  }
  
  public Scheduling buildScheduling() {
    return this.scheduling != null ? this.scheduling.build() : null;
  }
  
  public A withScheduling(Scheduling scheduling) {
    this._visitables.remove("scheduling");
    if (scheduling != null) {
        this.scheduling = new SchedulingBuilder(scheduling);
        this._visitables.get("scheduling").add(this.scheduling);
    } else {
        this.scheduling = null;
        this._visitables.get("scheduling").remove(this.scheduling);
    }
    return (A) this;
  }
  
  public boolean hasScheduling() {
    return this.scheduling != null;
  }
  
  public SchedulingNested<A> withNewScheduling() {
    return new SchedulingNested(null);
  }
  
  public SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
    return new SchedulingNested(item);
  }
  
  public SchedulingNested<A> editScheduling() {
    return withNewSchedulingLike(java.util.Optional.ofNullable(buildScheduling()).orElse(null));
  }
  
  public SchedulingNested<A> editOrNewScheduling() {
    return withNewSchedulingLike(java.util.Optional.ofNullable(buildScheduling()).orElse(new SchedulingBuilder().build()));
  }
  
  public SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
    return withNewSchedulingLike(java.util.Optional.ofNullable(buildScheduling()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuntimeClassFluent that = (RuntimeClassFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(handler, that.handler)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(overhead, that.overhead)) return false;
    if (!java.util.Objects.equals(scheduling, that.scheduling)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  handler,  kind,  metadata,  overhead,  scheduling,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (handler != null) { sb.append("handler:"); sb.append(handler + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (overhead != null) { sb.append("overhead:"); sb.append(overhead + ","); }
    if (scheduling != null) { sb.append("scheduling:"); sb.append(scheduling + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) RuntimeClassFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class OverheadNested<N> extends OverheadFluent<OverheadNested<N>> implements Nested<N>{
    OverheadNested(Overhead item) {
      this.builder = new OverheadBuilder(this, item);
    }
    OverheadBuilder builder;
    
    public N and() {
      return (N) RuntimeClassFluent.this.withOverhead(builder.build());
    }
    
    public N endOverhead() {
      return and();
    }
    
  
  }
  public class SchedulingNested<N> extends SchedulingFluent<SchedulingNested<N>> implements Nested<N>{
    SchedulingNested(Scheduling item) {
      this.builder = new SchedulingBuilder(this, item);
    }
    SchedulingBuilder builder;
    
    public N and() {
      return (N) RuntimeClassFluent.this.withScheduling(builder.build());
    }
    
    public N endScheduling() {
      return and();
    }
    
  
  }

}