package io.fabric8.kubernetes.api.model.node.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuntimeClassFluentImpl<A extends RuntimeClassFluent<A>> extends BaseFluent<A> implements RuntimeClassFluent<A>{
  public RuntimeClassFluentImpl() {
  }
  public RuntimeClassFluentImpl(RuntimeClass instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withHandler(instance.getHandler());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withOverhead(instance.getOverhead());
      this.withScheduling(instance.getScheduling());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String handler;
  private String kind;
  private ObjectMetaBuilder metadata;
  private OverheadBuilder overhead;
  private SchedulingBuilder scheduling;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getHandler() {
    return this.handler;
  }
  public A withHandler(String handler) {
    this.handler=handler; return (A) this;
  }
  public Boolean hasHandler() {
    return this.handler != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public RuntimeClassFluentImpl.MetadataNested<A> withNewMetadata() {
    return new RuntimeClassFluentImpl.MetadataNestedImpl();
  }
  public RuntimeClassFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new RuntimeClassFluentImpl.MetadataNestedImpl(item);
  }
  public RuntimeClassFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public RuntimeClassFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public RuntimeClassFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOverhead instead.
   * @return The buildable object.
   */
  @Deprecated
  public Overhead getOverhead() {
    return this.overhead!=null ?this.overhead.build():null;
  }
  public Overhead buildOverhead() {
    return this.overhead!=null ?this.overhead.build():null;
  }
  public A withOverhead(Overhead overhead) {
    _visitables.get("overhead").remove(this.overhead);
    if (overhead!=null){ this.overhead= new OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} else { this.overhead = null; _visitables.get("overhead").remove(this.overhead); } return (A) this;
  }
  public Boolean hasOverhead() {
    return this.overhead != null;
  }
  public RuntimeClassFluentImpl.OverheadNested<A> withNewOverhead() {
    return new RuntimeClassFluentImpl.OverheadNestedImpl();
  }
  public RuntimeClassFluentImpl.OverheadNested<A> withNewOverheadLike(Overhead item) {
    return new RuntimeClassFluentImpl.OverheadNestedImpl(item);
  }
  public RuntimeClassFluentImpl.OverheadNested<A> editOverhead() {
    return withNewOverheadLike(getOverhead());
  }
  public RuntimeClassFluentImpl.OverheadNested<A> editOrNewOverhead() {
    return withNewOverheadLike(getOverhead() != null ? getOverhead(): new OverheadBuilder().build());
  }
  public RuntimeClassFluentImpl.OverheadNested<A> editOrNewOverheadLike(Overhead item) {
    return withNewOverheadLike(getOverhead() != null ? getOverhead(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildScheduling instead.
   * @return The buildable object.
   */
  @Deprecated
  public Scheduling getScheduling() {
    return this.scheduling!=null ?this.scheduling.build():null;
  }
  public Scheduling buildScheduling() {
    return this.scheduling!=null ?this.scheduling.build():null;
  }
  public A withScheduling(Scheduling scheduling) {
    _visitables.get("scheduling").remove(this.scheduling);
    if (scheduling!=null){ this.scheduling= new SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} else { this.scheduling = null; _visitables.get("scheduling").remove(this.scheduling); } return (A) this;
  }
  public Boolean hasScheduling() {
    return this.scheduling != null;
  }
  public RuntimeClassFluentImpl.SchedulingNested<A> withNewScheduling() {
    return new RuntimeClassFluentImpl.SchedulingNestedImpl();
  }
  public RuntimeClassFluentImpl.SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
    return new RuntimeClassFluentImpl.SchedulingNestedImpl(item);
  }
  public RuntimeClassFluentImpl.SchedulingNested<A> editScheduling() {
    return withNewSchedulingLike(getScheduling());
  }
  public RuntimeClassFluentImpl.SchedulingNested<A> editOrNewScheduling() {
    return withNewSchedulingLike(getScheduling() != null ? getScheduling(): new SchedulingBuilder().build());
  }
  public RuntimeClassFluentImpl.SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
    return withNewSchedulingLike(getScheduling() != null ? getScheduling(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuntimeClassFluentImpl that = (RuntimeClassFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(handler, that.handler)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(overhead, that.overhead)) return false;

    if (!java.util.Objects.equals(scheduling, that.scheduling)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  handler,  kind,  metadata,  overhead,  scheduling,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (handler != null) { sb.append("handler:"); sb.append(handler + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (overhead != null) { sb.append("overhead:"); sb.append(overhead + ","); }
    if (scheduling != null) { sb.append("scheduling:"); sb.append(scheduling + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<RuntimeClassFluentImpl.MetadataNested<N>> implements RuntimeClassFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) RuntimeClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class OverheadNestedImpl<N> extends OverheadFluentImpl<RuntimeClassFluentImpl.OverheadNested<N>> implements RuntimeClassFluentImpl.OverheadNested<N>,Nested<N>{
    OverheadNestedImpl(Overhead item) {
      this.builder = new OverheadBuilder(this, item);
    }
    OverheadNestedImpl() {
      this.builder = new OverheadBuilder(this);
    }
    OverheadBuilder builder;
    public N and() {
      return (N) RuntimeClassFluentImpl.this.withOverhead(builder.build());
    }
    public N endOverhead() {
      return and();
    }
    
  }
  class SchedulingNestedImpl<N> extends SchedulingFluentImpl<RuntimeClassFluentImpl.SchedulingNested<N>> implements RuntimeClassFluentImpl.SchedulingNested<N>,Nested<N>{
    SchedulingNestedImpl(Scheduling item) {
      this.builder = new SchedulingBuilder(this, item);
    }
    SchedulingNestedImpl() {
      this.builder = new SchedulingBuilder(this);
    }
    SchedulingBuilder builder;
    public N and() {
      return (N) RuntimeClassFluentImpl.this.withScheduling(builder.build());
    }
    public N endScheduling() {
      return and();
    }
    
  }
  
}