package io.fabric8.kubernetes.api.model.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuntimeClassSpecBuilder extends RuntimeClassSpecFluentImpl<RuntimeClassSpecBuilder> implements VisitableBuilder<RuntimeClassSpec,RuntimeClassSpecBuilder>{
  public RuntimeClassSpecBuilder() {
    this(false);
  }
  public RuntimeClassSpecBuilder(Boolean validationEnabled) {
    this(new RuntimeClassSpec(), validationEnabled);
  }
  public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuntimeClassSpec(), validationEnabled);
  }
  public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent,RuntimeClassSpec instance) {
    this(fluent, instance, false);
  }
  public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent,RuntimeClassSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withOverhead(instance.getOverhead());
      fluent.withRuntimeHandler(instance.getRuntimeHandler());
      fluent.withScheduling(instance.getScheduling());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RuntimeClassSpecBuilder(RuntimeClassSpec instance) {
    this(instance,false);
  }
  public RuntimeClassSpecBuilder(RuntimeClassSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withOverhead(instance.getOverhead());
      this.withRuntimeHandler(instance.getRuntimeHandler());
      this.withScheduling(instance.getScheduling());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RuntimeClassSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RuntimeClassSpec build() {
    RuntimeClassSpec buildable = new RuntimeClassSpec(fluent.getOverhead(),fluent.getRuntimeHandler(),fluent.getScheduling());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}