package io.fabric8.kubernetes.api.model.node.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuntimeClassSpecFluent<A extends RuntimeClassSpecFluent<A>> extends BaseFluent<A>{
  public RuntimeClassSpecFluent() {
  }
  public RuntimeClassSpecFluent(RuntimeClassSpec instance) {
    instance = (instance != null ? instance : new RuntimeClassSpec());

    if (instance != null) {
      this.withOverhead(instance.getOverhead());
      this.withRuntimeHandler(instance.getRuntimeHandler());
      this.withScheduling(instance.getScheduling());
      this.withOverhead(instance.getOverhead());
      this.withRuntimeHandler(instance.getRuntimeHandler());
      this.withScheduling(instance.getScheduling());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private OverheadBuilder overhead;
  private String runtimeHandler;
  private SchedulingBuilder scheduling;
  private Map<String,Object> additionalProperties;
  public Overhead buildOverhead() {
    return this.overhead!=null ?this.overhead.build():null;
  }
  public A withOverhead(Overhead overhead) {
    _visitables.get("overhead").remove(this.overhead);
    if (overhead!=null){ this.overhead= new OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} else { this.overhead = null; _visitables.get("overhead").remove(this.overhead); } return (A) this;
  }
  public boolean hasOverhead() {
    return this.overhead != null;
  }
  public OverheadNested<A> withNewOverhead() {
    return new OverheadNested(null);
  }
  public OverheadNested<A> withNewOverheadLike(Overhead item) {
    return new OverheadNested(item);
  }
  public OverheadNested<A> editOverhead() {
    return withNewOverheadLike(java.util.Optional.ofNullable(buildOverhead()).orElse(null));
  }
  public OverheadNested<A> editOrNewOverhead() {
    return withNewOverheadLike(java.util.Optional.ofNullable(buildOverhead()).orElse(new OverheadBuilder().build()));
  }
  public OverheadNested<A> editOrNewOverheadLike(Overhead item) {
    return withNewOverheadLike(java.util.Optional.ofNullable(buildOverhead()).orElse(item));
  }
  public String getRuntimeHandler() {
    return this.runtimeHandler;
  }
  public A withRuntimeHandler(String runtimeHandler) {
    this.runtimeHandler=runtimeHandler; return (A) this;
  }
  public boolean hasRuntimeHandler() {
    return this.runtimeHandler != null;
  }
  public Scheduling buildScheduling() {
    return this.scheduling!=null ?this.scheduling.build():null;
  }
  public A withScheduling(Scheduling scheduling) {
    _visitables.get("scheduling").remove(this.scheduling);
    if (scheduling!=null){ this.scheduling= new SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} else { this.scheduling = null; _visitables.get("scheduling").remove(this.scheduling); } return (A) this;
  }
  public boolean hasScheduling() {
    return this.scheduling != null;
  }
  public SchedulingNested<A> withNewScheduling() {
    return new SchedulingNested(null);
  }
  public SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
    return new SchedulingNested(item);
  }
  public SchedulingNested<A> editScheduling() {
    return withNewSchedulingLike(java.util.Optional.ofNullable(buildScheduling()).orElse(null));
  }
  public SchedulingNested<A> editOrNewScheduling() {
    return withNewSchedulingLike(java.util.Optional.ofNullable(buildScheduling()).orElse(new SchedulingBuilder().build()));
  }
  public SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
    return withNewSchedulingLike(java.util.Optional.ofNullable(buildScheduling()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuntimeClassSpecFluent that = (RuntimeClassSpecFluent) o;
    if (!java.util.Objects.equals(overhead, that.overhead)) return false;

    if (!java.util.Objects.equals(runtimeHandler, that.runtimeHandler)) return false;

    if (!java.util.Objects.equals(scheduling, that.scheduling)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(overhead,  runtimeHandler,  scheduling,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (overhead != null) { sb.append("overhead:"); sb.append(overhead + ","); }
    if (runtimeHandler != null) { sb.append("runtimeHandler:"); sb.append(runtimeHandler + ","); }
    if (scheduling != null) { sb.append("scheduling:"); sb.append(scheduling + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OverheadNested<N> extends OverheadFluent<OverheadNested<N>> implements Nested<N>{
    OverheadNested(Overhead item) {
      this.builder = new OverheadBuilder(this, item);
    }
    OverheadBuilder builder;
    public N and() {
      return (N) RuntimeClassSpecFluent.this.withOverhead(builder.build());
    }
    public N endOverhead() {
      return and();
    }
    
  }
  public class SchedulingNested<N> extends SchedulingFluent<SchedulingNested<N>> implements Nested<N>{
    SchedulingNested(Scheduling item) {
      this.builder = new SchedulingBuilder(this, item);
    }
    SchedulingBuilder builder;
    public N and() {
      return (N) RuntimeClassSpecFluent.this.withScheduling(builder.build());
    }
    public N endScheduling() {
      return and();
    }
    
  }
  
}