package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuntimeClassBuilder extends RuntimeClassFluent<RuntimeClassBuilder> implements VisitableBuilder<RuntimeClass,RuntimeClassBuilder>{
  public RuntimeClassBuilder() {
    this(false);
  }
  public RuntimeClassBuilder(Boolean validationEnabled) {
    this(new RuntimeClass(), validationEnabled);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent) {
    this(fluent, false);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuntimeClass(), validationEnabled);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance) {
    this(fluent, instance, false);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RuntimeClass());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withHandler(instance.getHandler());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withOverhead(instance.getOverhead());
      fluent.withScheduling(instance.getScheduling());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withHandler(instance.getHandler());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withOverhead(instance.getOverhead());
      fluent.withScheduling(instance.getScheduling());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RuntimeClassBuilder(RuntimeClass instance) {
    this(instance,false);
  }
  public RuntimeClassBuilder(RuntimeClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RuntimeClass());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withHandler(instance.getHandler());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withOverhead(instance.getOverhead());
      this.withScheduling(instance.getScheduling());
      this.withApiVersion(instance.getApiVersion());
      this.withHandler(instance.getHandler());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withOverhead(instance.getOverhead());
      this.withScheduling(instance.getScheduling());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RuntimeClassFluent<?> fluent;
  Boolean validationEnabled;
  public RuntimeClass build() {
    RuntimeClass buildable = new RuntimeClass(fluent.getApiVersion(),fluent.getHandler(),fluent.getKind(),fluent.buildMetadata(),fluent.buildOverhead(),fluent.buildScheduling());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}