package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuntimeClassListBuilder extends RuntimeClassListFluent<RuntimeClassListBuilder> implements VisitableBuilder<RuntimeClassList,RuntimeClassListBuilder>{
  public RuntimeClassListBuilder() {
    this(false);
  }
  public RuntimeClassListBuilder(Boolean validationEnabled) {
    this(new RuntimeClassList(), validationEnabled);
  }
  public RuntimeClassListBuilder(RuntimeClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public RuntimeClassListBuilder(RuntimeClassListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuntimeClassList(), validationEnabled);
  }
  public RuntimeClassListBuilder(RuntimeClassListFluent<?> fluent,RuntimeClassList instance) {
    this(fluent, instance, false);
  }
  public RuntimeClassListBuilder(RuntimeClassListFluent<?> fluent,RuntimeClassList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RuntimeClassList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RuntimeClassListBuilder(RuntimeClassList instance) {
    this(instance,false);
  }
  public RuntimeClassListBuilder(RuntimeClassList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RuntimeClassList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RuntimeClassListFluent<?> fluent;
  Boolean validationEnabled;
  public RuntimeClassList build() {
    RuntimeClassList buildable = new RuntimeClassList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}