package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RunAsUserStrategyOptionsBuilder extends RunAsUserStrategyOptionsFluentImpl<RunAsUserStrategyOptionsBuilder> implements VisitableBuilder<RunAsUserStrategyOptions,RunAsUserStrategyOptionsBuilder>{

    RunAsUserStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public RunAsUserStrategyOptionsBuilder(){
            this(true);
    }
    public RunAsUserStrategyOptionsBuilder(Boolean validationEnabled){
            this(new RunAsUserStrategyOptions(), validationEnabled);
    }
    public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RunAsUserStrategyOptions(), validationEnabled);
    }
    public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent,RunAsUserStrategyOptions instance){
            this(fluent, instance, true);
    }
    public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent,RunAsUserStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges()); 
            fluent.withRule(instance.getRule()); 
            this.validationEnabled = validationEnabled; 
    }
    public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptions instance){
            this(instance,true);
    }
    public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges()); 
            this.withRule(instance.getRule()); 
            this.validationEnabled = validationEnabled; 
    }

    public RunAsUserStrategyOptions build(){
            RunAsUserStrategyOptions buildable = new RunAsUserStrategyOptions(fluent.getRanges(),fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RunAsUserStrategyOptionsBuilder that = (RunAsUserStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
