/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyFluent;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpec;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpecBuilder;
import io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpecFluentImpl;
import java.util.Objects;

public class PodSecurityPolicyFluentImpl<A extends PodSecurityPolicyFluent<A>>
extends BaseFluent<A>
implements PodSecurityPolicyFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PodSecurityPolicySpecBuilder spec;

    public PodSecurityPolicyFluentImpl() {
    }

    public PodSecurityPolicyFluentImpl(PodSecurityPolicy instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(int[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(char[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2) {
        return this.withApiVersion(new String(arg1, arg2));
    }

    @Override
    public A withNewApiVersion(byte[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(char[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(int[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(char[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2) {
        return this.withKind(new String(arg1, arg2));
    }

    @Override
    public A withNewKind(byte[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(char[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withKind(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PodSecurityPolicyFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodSecurityPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodSecurityPolicyFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodSecurityPolicyFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PodSecurityPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public PodSecurityPolicySpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public PodSecurityPolicySpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(PodSecurityPolicySpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new PodSecurityPolicySpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public PodSecurityPolicyFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PodSecurityPolicyFluent.SpecNested<A> withNewSpecLike(PodSecurityPolicySpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PodSecurityPolicyFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PodSecurityPolicyFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new PodSecurityPolicySpecBuilder().build());
    }

    @Override
    public PodSecurityPolicyFluent.SpecNested<A> editOrNewSpecLike(PodSecurityPolicySpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSecurityPolicyFluentImpl that = (PodSecurityPolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.spec != null ? !this.spec.equals(that.spec) : that.spec != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, super.hashCode());
    }

    public class SpecNestedImpl<N>
    extends PodSecurityPolicySpecFluentImpl<PodSecurityPolicyFluent.SpecNested<N>>
    implements PodSecurityPolicyFluent.SpecNested<N>,
    Nested<N> {
        private final PodSecurityPolicySpecBuilder builder;

        SpecNestedImpl(PodSecurityPolicySpec item) {
            this.builder = new PodSecurityPolicySpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PodSecurityPolicySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicyFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PodSecurityPolicyFluent.MetadataNested<N>>
    implements PodSecurityPolicyFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

