package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RunAsGroupStrategyOptionsBuilder extends RunAsGroupStrategyOptionsFluentImpl<RunAsGroupStrategyOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<RunAsGroupStrategyOptions,RunAsGroupStrategyOptionsBuilder> {

    RunAsGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public RunAsGroupStrategyOptionsBuilder() {
        this(true);
    }

    public RunAsGroupStrategyOptionsBuilder(Boolean validationEnabled) {
        this(new RunAsGroupStrategyOptions(), validationEnabled);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RunAsGroupStrategyOptions(), validationEnabled);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent,RunAsGroupStrategyOptions instance) {
        this(fluent, instance, true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent,RunAsGroupStrategyOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRanges(instance.getRanges()); 
        fluent.withRule(instance.getRule()); 
        this.validationEnabled = validationEnabled; 
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance) {
        this(instance,true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withRanges(instance.getRanges()); 
        this.withRule(instance.getRule()); 
        this.validationEnabled = validationEnabled; 
    }

    public RunAsGroupStrategyOptions build() {
        RunAsGroupStrategyOptions buildable = new RunAsGroupStrategyOptions(fluent.getRanges(),fluent.getRule());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RunAsGroupStrategyOptionsBuilder that = (RunAsGroupStrategyOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
