package io.fabric8.kubernetes.api.model.policy;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface PodDisruptionBudgetStatusFluent<A extends PodDisruptionBudgetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getCurrentHealthy();
    public A withCurrentHealthy(Integer currentHealthy);
    public Boolean hasCurrentHealthy();
    public A withNewCurrentHealthy(int arg0);
    public Integer getDesiredHealthy();
    public A withDesiredHealthy(Integer desiredHealthy);
    public Boolean hasDesiredHealthy();
    public A withNewDesiredHealthy(int arg0);
    public A addToDisruptedPods(String key,String value);
    public A addToDisruptedPods(java.util.Map<String,String> map);
    public A removeFromDisruptedPods(String key);
    public A removeFromDisruptedPods(java.util.Map<String,String> map);
    public java.util.Map<String,String> getDisruptedPods();
    public <K extends Object,V extends Object>A withDisruptedPods(java.util.Map<String,String> disruptedPods);
    public Boolean hasDisruptedPods();
    public Integer getDisruptionsAllowed();
    public A withDisruptionsAllowed(Integer disruptionsAllowed);
    public Boolean hasDisruptionsAllowed();
    public A withNewDisruptionsAllowed(int arg0);
    public Integer getExpectedPods();
    public A withExpectedPods(Integer expectedPods);
    public Boolean hasExpectedPods();
    public A withNewExpectedPods(int arg0);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
}
