package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class FSGroupStrategyOptionsFluentImpl<A extends io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent<A> {

    private java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder> ranges =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder>();
    private java.lang.String rule;

    public FSGroupStrategyOptionsFluentImpl() {
    }

    public FSGroupStrategyOptionsFluentImpl(io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions instance) {
        this.withRanges(instance.getRanges()); 
        this.withRule(instance.getRule()); 
    }

    public A addToRanges(int index,io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item) {
        if (this.ranges == null) {this.ranges = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder>();}
        io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(item);_visitables.get("ranges").add(index >= 0 ? index : _visitables.get("ranges").size(), builder);this.ranges.add(index >= 0 ? index : ranges.size(), builder); return (A)this;
    }

    public A setToRanges(int index,io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item) {
        if (this.ranges == null) {this.ranges = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder>();}
        io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(item);
        if (index < 0 || index >= _visitables.get("ranges").size()) { _visitables.get("ranges").add(builder); } else { _visitables.get("ranges").set(index, builder);}
        if (index < 0 || index >= ranges.size()) { ranges.add(builder); } else { ranges.set(index, builder);}
         return (A)this;
    }

    public A addToRanges(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange... items) {
        if (this.ranges == null) {this.ranges = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder>();}
        for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A addAllToRanges(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange> items) {
        if (this.ranges == null) {this.ranges = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder>();}
        for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A removeFromRanges(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange... items) {
        for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(item);_visitables.get("ranges").remove(builder);if (this.ranges != null) {this.ranges.remove(builder);}} return (A)this;
    }

    public A removeAllFromRanges(java.util.Collection<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange> items) {
        for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item : items) {io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(item);_visitables.get("ranges").remove(builder);if (this.ranges != null) {this.ranges.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRanges(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder> predicate) {
        if (ranges == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder> each = ranges.iterator();
        final List visitables = _visitables.get("ranges");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRanges instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange> getRanges() {
        return build(ranges);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange> buildRanges() {
        return build(ranges);
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange buildRange(int index) {
        return this.ranges.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange buildFirstRange() {
        return this.ranges.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange buildLastRange() {
        return this.ranges.get(ranges.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange buildMatchingRange(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder item: ranges) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingRange(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder item: ranges) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRanges(java.util.List<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange> ranges) {
        if (this.ranges != null) { _visitables.get("ranges").removeAll(this.ranges);}
        if (ranges != null) {this.ranges = new java.util.ArrayList<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder>(); for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item : ranges){this.addToRanges(item);}} else { this.ranges = null;} return (A) this;
    }

    public A withRanges(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange... ranges) {
        if (this.ranges != null) {this.ranges.clear();}
        if (ranges != null) {for (io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item :ranges){ this.addToRanges(item);}} return (A) this;
    }

    public java.lang.Boolean hasRanges() {
        return ranges != null && !ranges.isEmpty();
    }

    public A addNewRange(java.lang.Long max,java.lang.Long min) {
        return (A)addToRanges(new IDRange(max, min));
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> addNewRange() {
        return new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluentImpl.RangesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> addNewRangeLike(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item) {
        return new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluentImpl.RangesNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> setNewRangeLike(int index,io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item) {
        return new io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluentImpl.RangesNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> editRange(int index) {
        if (ranges.size() <= index) throw new RuntimeException("Can't edit ranges. Index exceeds size.");
        return setNewRangeLike(index, buildRange(index));
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> editFirstRange() {
        if (ranges.size() == 0) throw new RuntimeException("Can't edit first ranges. The list is empty.");
        return setNewRangeLike(0, buildRange(0));
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> editLastRange() {
        int index = ranges.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ranges. The list is empty.");
        return setNewRangeLike(index, buildRange(index));
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<A> editMatchingRange(java.util.function.Predicate<io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ranges.size();i++) { 
        if (predicate.test(ranges.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ranges. No match found.");
        return setNewRangeLike(index, buildRange(index));
    }

    public java.lang.String getRule() {
        return this.rule;
    }

    public A withRule(java.lang.String rule) {
        this.rule=rule; return (A) this;
    }

    public java.lang.Boolean hasRule() {
        return this.rule != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRule instead.
     */
        public A withNewRule(java.lang.String arg0) {
        return (A)withRule(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FSGroupStrategyOptionsFluentImpl that = (FSGroupStrategyOptionsFluentImpl) o;
        if (ranges != null ? !ranges.equals(that.ranges) :that.ranges != null) return false;
        if (rule != null ? !rule.equals(that.rule) :that.rule != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ranges,  rule,  super.hashCode());
    }

    public class RangesNestedImpl<N> extends io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<N>> implements io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent.RangesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder builder;
        private final int index;

            RangesNestedImpl(int index,io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(this, item);
                        
            }

            RangesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder(this);
                        
            }

            public N and() {
                return (N) FSGroupStrategyOptionsFluentImpl.this.setToRanges(index,builder.build());
            }

            public N endRange() {
                return and();
            }
    }


}
