package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RunAsGroupStrategyOptionsBuilder extends RunAsGroupStrategyOptionsFluentImpl<RunAsGroupStrategyOptionsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions,io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder>{
  public RunAsGroupStrategyOptionsBuilder() {
    this(false);
  }
  public RunAsGroupStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new RunAsGroupStrategyOptions(), validationEnabled);
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public RunAsGroupStrategyOptionsBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RunAsGroupStrategyOptions(), validationEnabled);
  }
  public RunAsGroupStrategyOptionsBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public RunAsGroupStrategyOptionsBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRanges(instance.getRanges()); 
    fluent.withRule(instance.getRule()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RunAsGroupStrategyOptionsBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions instance) {
    this(instance,false);
  }
  public RunAsGroupStrategyOptionsBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRanges(instance.getRanges()); 
    this.withRule(instance.getRule()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions build() {
    RunAsGroupStrategyOptions buildable = new RunAsGroupStrategyOptions(fluent.getRanges(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}