package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDisruptionBudgetSpecBuilder extends PodDisruptionBudgetSpecFluentImpl<PodDisruptionBudgetSpecBuilder> implements VisitableBuilder<PodDisruptionBudgetSpec,PodDisruptionBudgetSpecBuilder>{
  public PodDisruptionBudgetSpecBuilder() {
    this(false);
  }
  public PodDisruptionBudgetSpecBuilder(Boolean validationEnabled) {
    this(new PodDisruptionBudgetSpec(), validationEnabled);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDisruptionBudgetSpec(), validationEnabled);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,PodDisruptionBudgetSpec instance) {
    this(fluent, instance, false);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,PodDisruptionBudgetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
    fluent.withMinAvailable(instance.getMinAvailable()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpec instance) {
    this(instance,false);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxUnavailable(instance.getMaxUnavailable()); 
    this.withMinAvailable(instance.getMinAvailable()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodDisruptionBudgetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodDisruptionBudgetSpec build() {
    PodDisruptionBudgetSpec buildable = new PodDisruptionBudgetSpec(fluent.getMaxUnavailable(),fluent.getMinAvailable(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}