package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EvictionBuilder extends EvictionFluent<EvictionBuilder> implements VisitableBuilder<Eviction,EvictionBuilder>{
  public EvictionBuilder() {
    this(false);
  }
  public EvictionBuilder(Boolean validationEnabled) {
    this(new Eviction(), validationEnabled);
  }
  public EvictionBuilder(EvictionFluent<?> fluent) {
    this(fluent, false);
  }
  public EvictionBuilder(EvictionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Eviction(), validationEnabled);
  }
  public EvictionBuilder(EvictionFluent<?> fluent,Eviction instance) {
    this(fluent, instance, false);
  }
  public EvictionBuilder(EvictionFluent<?> fluent,Eviction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Eviction());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDeleteOptions(instance.getDeleteOptions());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDeleteOptions(instance.getDeleteOptions());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EvictionBuilder(Eviction instance) {
    this(instance,false);
  }
  public EvictionBuilder(Eviction instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Eviction());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDeleteOptions(instance.getDeleteOptions());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withDeleteOptions(instance.getDeleteOptions());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EvictionFluent<?> fluent;
  Boolean validationEnabled;
  public Eviction build() {
    Eviction buildable = new Eviction(fluent.getApiVersion(),fluent.getDeleteOptions(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}