package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AllowedHostPathBuilder extends AllowedHostPathFluent<AllowedHostPathBuilder> implements VisitableBuilder<AllowedHostPath,AllowedHostPathBuilder>{
  public AllowedHostPathBuilder() {
    this(false);
  }
  public AllowedHostPathBuilder(Boolean validationEnabled) {
    this(new AllowedHostPath(), validationEnabled);
  }
  public AllowedHostPathBuilder(AllowedHostPathFluent<?> fluent) {
    this(fluent, false);
  }
  public AllowedHostPathBuilder(AllowedHostPathFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AllowedHostPath(), validationEnabled);
  }
  public AllowedHostPathBuilder(AllowedHostPathFluent<?> fluent,AllowedHostPath instance) {
    this(fluent, instance, false);
  }
  public AllowedHostPathBuilder(AllowedHostPathFluent<?> fluent,AllowedHostPath instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AllowedHostPath());

    if (instance != null) {
      fluent.withPathPrefix(instance.getPathPrefix());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withPathPrefix(instance.getPathPrefix());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AllowedHostPathBuilder(AllowedHostPath instance) {
    this(instance,false);
  }
  public AllowedHostPathBuilder(AllowedHostPath instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AllowedHostPath());

    if (instance != null) {
      this.withPathPrefix(instance.getPathPrefix());
      this.withReadOnly(instance.getReadOnly());
      this.withPathPrefix(instance.getPathPrefix());
      this.withReadOnly(instance.getReadOnly());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AllowedHostPathFluent<?> fluent;
  Boolean validationEnabled;
  public AllowedHostPath build() {
    AllowedHostPath buildable = new AllowedHostPath(fluent.getPathPrefix(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}